% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscfuns.R
\name{fixest_data}
\alias{fixest_data}
\title{Retrieves the data set used for a \code{fixest} estimation}
\usage{
fixest_data(x, sample = "original")
}
\arguments{
\item{x}{An object of class \code{fixest} or \code{fixest_multi}. For example obtained from \code{\link{feols}} or \code{\link{feglm}}.}

\item{sample}{Either "original" (default) or "estimation". If equal to "original",
it matches the original data set. If equal to "estimation", the rows of the data set
returned matches the observations used for the estimation.}
}
\value{
It returns a data.frame equal to the original data set used for the estimation, when the function was called.

If \code{sample = "estimation"}, only the lines used for the estimation are returned.

In case of a \code{fixest_multi} object, it returns the data set of the first estimation object.
So in that case it does not make sense to use \code{sample = "estimation"} since
the samples may be inconsistent across the different estimations.
}
\description{
Retrieves the original data set used to estimate a \code{fixest} or \code{fixest_multi} model.
Note that this is the original data set and not the data used for the estimation (i.e. it can have more rows).
}
\examples{

base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
base$y[1:5] = NA

est = feols(y ~ x1 + x2, base)

# the original data set
head(fixest_data(est))

# the data set, with only the lines used for the estimation
head(fixest_data(est, sample = "est"))


}
