% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\docType{data}
\name{setFixest_print.type}
\alias{setFixest_print.type}
\alias{getFixest_print.type}
\title{Sets/gets what \code{print} does to \code{fixest} estimations}
\format{
An object of class \code{function} of length 1.
}
\usage{
setFixest_print.type(x)

getFixest_print.type
}
\arguments{
\item{x}{Either \code{"table"} or \code{"coef"}.}
}
\description{
Sets/gets the default behavior of the \code{print} method for non-summary \code{fixest} estimations. Default is to display the coefficients table but it can be changed to displaying only the coefficients.
}
\examples{

res = feols(Sepal.Length ~ Sepal.Width + Petal.Length, iris)
# default is coef. table:
res
# can be changed to only the coefficients:
print(res, type = "coef")
setFixest_print.type("coef")
res # only the coefs

# back to default
setFixest_print.type("table")

}
\author{
Laurent Berge
}
\keyword{datasets}
