% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{terms.fixest}
\alias{terms.fixest}
\title{Extract the terms}
\usage{
\method{terms}{fixest}(x, ...)
}
\arguments{
\item{x}{A \code{fixest} object. Obtained using the functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.}

\item{...}{Not currently used.}
}
\value{
An object of class \code{c("terms", "formula")} which contains the terms representation of a symbolic model.
}
\description{
This function extracts the terms of a \code{fixest} estimation, excluding the fixed-effects part.
}
\examples{

# simple estimation on iris data, using "Species" fixed-effects
res = feols(Sepal.Length ~ Sepal.Width*Petal.Length +
            Petal.Width | Species, iris)

# Terms of the linear part
terms(res)


}
