% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shap.R
\name{add_shap}
\alias{add_shap}
\alias{add_shap.default}
\alias{add_shap.flashlight}
\alias{add_shap.multiflashlight}
\title{Add SHAP values to (multi-)flashlight}
\usage{
add_shap(x, ...)

\method{add_shap}{default}(x, ...)

\method{add_shap}{flashlight}(
  x,
  v = NULL,
  visit_strategy = c("permutation", "importance", "v"),
  n_shap = 200,
  n_max = Inf,
  n_perm = 12,
  seed = NULL,
  use_linkinv = FALSE,
  verbose = TRUE,
  variable_name = "variable",
  ...
)

\method{add_shap}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed from or to other methods.}

\item{v}{Vector of variables to assess contribution for. Defaults to all except those specified by "y", "w" and "by".}

\item{visit_strategy}{In what sequence should variables be visited? By \code{n_perm} "permutation" (slow), by "importance" (fast), or as "v" (not recommended).}

\item{n_shap}{Number of SHAP decompositions to calculate.}

\item{n_max}{Maximum number of rows in \code{data} to consider in the reference data. Set to lower value if \code{data} is large.}

\item{n_perm}{Number of permutations of random visit sequences. Only used if \code{visit_strategy = "permutation"}.}

\item{seed}{An integer random seed.}

\item{use_linkinv}{Should retransformation function be applied? We suggest to keep the default (\code{FALSE}) as the values can be retransformed later.}

\item{verbose}{Should progress bar be shown? Default is \code{TRUE}.}

\item{variable_name}{Column name in \code{data} of element "shap" containing the variable names. Defaults to "variable".}
}
\value{
An object of class \code{flashlight} or \code{multiflashlight} with additional element "shap" of class "shap" (and "list").
}
\description{
The function calls \code{light_breakdown} for \code{n_shap} observations and adds the resulting (approximate) SHAP decompositions as static element "shap" to the (multi)-flashlight for further analyses. We offer two approximations to SHAP: For \code{visit_strategy = "importance"}, the breakdown algorithm in [1] is used with importance based visit order. Use the default \code{visit_strategy = "permutation"} to run breakdown for multiple random permutations, averaging the results. This approximation will be closer to exact SHAP values, but very slow. Most available arguments can be chosen to reduce computation time.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Variable attribution to single observation for a flashlight.

\item \code{multiflashlight}: Add SHAP to multiflashlight.
}}

\examples{
\dontrun{
fit <- lm(Sepal.Length ~ . + Petal.Length:Species, data = iris)
x <- flashlight(model = fit, label = "lm", data = iris, y = "Sepal.Length")
x <- add_shap(x)
is.shap(x$shap)
plot(light_importance(x, type = "shap"))
plot(light_scatter(x, type = "shap", v = "Petal.Length"))
}
}
\references{
[1] A. Gosiewska and P. Biecek (2019). IBREAKDOWN: Uncertainty of model explanations for non-additive predictive models. ArXiv <arxiv.org/abs/1903.11420>.
}
