% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexicon_decoder.R
\name{LexiconDecoder}
\alias{LexiconDecoder}
\title{LexiconDecoder}
\description{
Decoder implements a beam seach decoder that finds the word transcription
W maximizing:
}
\details{
AM(W) + lmWeight_ * log(P_{lm}(W)) + wordScore_ * |W_known| + unkScore_ * 
|W_unknown| + silScore_ * |{i| pi_i = <sil>}|

where P_{lm}(W) is the language model score, pi_i is the value for the i-th
frame in the path leading to W and AM(W) is the (unnormalized) emitting model
score of the transcription W. Note that the lexicon is used to limit the
search space and all candidate words are generated from it if unkScore is
-inf, otherwise <UNK> will be generated for OOVs.
}
\section{Super class}{
\code{\link[flashlighttext:Decoder]{flashlighttext::Decoder}} -> \code{LexiconDecoder}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LexiconDecoder-new}{\code{LexiconDecoder$new()}}
\item \href{#method-LexiconDecoder-n_hypothesis}{\code{LexiconDecoder$n_hypothesis()}}
\item \href{#method-LexiconDecoder-clone}{\code{LexiconDecoder$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="decode"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-decode'><code>flashlighttext::Decoder$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="get_all_final_hypothesis"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-get_all_final_hypothesis'><code>flashlighttext::Decoder$get_all_final_hypothesis()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="get_best_hypothesis"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-get_best_hypothesis'><code>flashlighttext::Decoder$get_best_hypothesis()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="n_decoded_frames_in_buffer"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-n_decoded_frames_in_buffer'><code>flashlighttext::Decoder$n_decoded_frames_in_buffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="flashlighttext" data-topic="Decoder" data-id="prune"><a href='../../flashlighttext/html/Decoder.html#method-Decoder-prune'><code>flashlighttext::Decoder$prune()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconDecoder-new"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconDecoder-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconDecoder$new(
  options,
  trie,
  lm,
  sil_token_idx,
  blank_token_idx,
  unk_token_idx,
  transitions,
  is_lm_token
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{options}}{a LexiconDecoderOptions instance}

\item{\code{trie}}{a Trie instance. Lexicon trie to restrict beam-search decoder}

\item{\code{lm}}{a LM instance (e.g. KenLM or ZeroLM)}

\item{\code{sil_token_idx}}{a character. The silence token index}

\item{\code{blank_token_idx}}{a character. The blank token index (for CTC)}

\item{\code{unk_token_idx}}{a character. The unkown token index}

\item{\code{transitions}}{a tensor. Matrix of transitions (for ASG criterion)}

\item{\code{is_lm_token}}{a is_lm_token}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
LexiconDecoder
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconDecoder-n_hypothesis"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconDecoder-n_hypothesis}{}}}
\subsection{Method \code{n_hypothesis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconDecoder$n_hypothesis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LexiconDecoder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LexiconDecoder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LexiconDecoder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
