% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviates.R
\name{deviate_ends}
\alias{deviate_ends}
\title{Return a deviate vector with deviates at the extreme rank}
\usage{
deviate_ends(k)
}
\arguments{
\item{k}{an integer. The number of components.}
}
\value{
An \code{rkhist} object.
}
\description{
Based on the formula given in Jolliffe and Primo (2008) this function returns
a vector with the right properties to test the presence of a deviate to
flatness at both extreme ranks in a rank histogram.
}
\details{
Although the deviate vector is not a rank histogram, this function returns
an \code{rkhist} object for the sake of simplicity. This allows for instance
to plot the vector.
}
\references{
Jolliffe, Ian T., and Cristina Primo. "Evaluating rank histograms using
decompositions of the chi-square test statistic." \emph{Monthly Weather
Review} 136.6 (2008): 2133-2139. doi:https://doi.org/10.1175/2007MWR2219.1
}
