% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkhist.R
\name{rkhist.list}
\alias{rkhist.list}
\title{Method of S3 generic function \code{rkhist} for \code{list} objects}
\usage{
\method{rkhist}{list}(fcst, obs, names = NULL, ...)
}
\arguments{
\item{fcst}{an object containing the ensemble forecasts. It must be a list,
each entry containing the forecast of one ensemble. The forecast of each
ensemble is a matrix whose rows contain one forecast.}

\item{obs}{an object containing the observation associated to the forecast in
\code{fcst}. It can be a vector or a list, whose length is the same as
the number of row in \code{fcst} If a vector, it is used as the observation
vector for all the ensemble in \code{fcst}. If it is a list, each entry is
associated to the same entry in \code{fcst}.}

\item{names}{a character vector. The row names in the returned \code{rkhist}
object. If missing, the row names are the names of the list \code{fcst}
(if any).}

\item{...}{additional arguments, passed to function \code{base::rank}.}
}
\value{
An S3 object of class \code{rkhist} (indeed an N-row matrix
containing the count for each rank, with \code{class} "rkhist"). N is the
length of \code{fcst}, i.e. the number of ensembles.
}
\description{
This is the method called when the \code{fcst} argument in function
\code{rkhist} is a list.
}
