% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getValue}
\alias{fxml_getValue}
\title{Value of an XML element}
\usage{
fxml_getValue(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The value of the XML element with ID \code{elemid}. \code{NA} is returned if the element has no value.
}
\description{
Returns the value of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get the value of the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_hasValue(xml.dataframe, 4)

}
\seealso{
\code{\link{fxml_hasValue}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
