% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-get-last-tag.R
\name{get_last_tag}
\alias{get_last_tag}
\title{The most recent tag}
\usage{
get_last_tag()
}
\value{
A one-row tibble with columns \code{name}, \code{ref} and \code{commit}.
For annotated tags (as created by fledge), \code{commit} may be different
from the SHA of the commit that this tag points to.
Use \code{\link[gert:git_commit]{gert::git_log()}} to find the actual commit.
}
\description{
Returns the most recent Git tag.
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  fledge::finalize_version()
  print(get_top_level_commits(since = NULL))
  print(fledge::get_last_tag())
})
}
