% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_sf.R
\name{decode_sf}
\alias{decode_sf}
\title{Wrapper function for decoding to simple features}
\usage{
decode_sf(encoded, crs = sf::NA_crs_)
}
\arguments{
\item{encoded}{character, encoded flexible polyline string.}

\item{crs}{integer or character, coordinate reference system to assign to the sf object (\code{default = sf::NA_crs_}).}
}
\value{
An \code{sf} object, containing the geometries of the decoded lines (Geometry type: \code{"LINESTRING"}).
}
\description{
A wrapper function for \code{\link{decode}} that converts the input polylines,
encoded in the flexible polyline enoding, to simple feature geometries of the sf package.
}
\note{
The function returns an sf object, therefore the input set of encoded polylines
must be of consistent dimension (e.g \code{"XY"}, \code{"XYM"} or \code{"XYZ"})
to meet the requirements of the constructor of sf objects. For mixed dimensions
use the \code{\link{decode}} function directly.
}
\examples{
# 2d line
decode_sf("BFoz5xJ67i1B1B7PzIhaxL7Y")

# 3d line
decode_sf("BlBoz5xJ67i1BU1B7PUzIhaUxL7YU")
}
