\name{summary.flexsurvreg}
\title{Summaries of fitted flexible survival models}
\alias{summary.flexsurvreg}
\concept{Survival}
\description{
  Return fitted survival, cumulative hazard or hazard
  at a series of times from a fitted \code{\link{flexsurvreg}} or
  \code{\link{flexsurvspline}} model.
}
\usage{
\method{summary}{flexsurvreg}(object, newdata=NULL, X=NULL,
                 type="survival", fn=NULL, t=NULL,
                 start=0, ci=TRUE, B=1000, cl=0.95,
                 tidy=FALSE, ...)
}
\arguments{
  \item{object}{Output from \code{\link{flexsurvreg}} or \code{\link{flexsurvspline}}, representing a fitted
    survival model object.}

  \item{newdata}{
    Data frame containing covariate values to produce fitted values for.
    Or a list that can be coerced to such a data frame.  There must be a
    column for every covariate in the model formula, and one row for
    every combination of covariates the fitted values are wanted for.
    These are in the same format as the original data, with factors as a
    single variable, not 0/1 contrasts.

    If this is omitted, if there are any continuous covariates, then a
    single summary is provided with all covariates set to their mean
    values in the data - for categorical covariates, the means of the
    0/1 indicator variables are taken.  If there are only factor
    covariates in the model, then all distinct groups are used by
    default.  }
  
  \item{X}{ Alternative way of defining covariate values to produce
    fitted values for.  Since version 0.4, \code{newdata} is an
    easier way that doesn't require the user to create factor contrasts,
    but \code{X} has been kept for backwards compatibility.

    Columns of \code{X} represent different covariates, and rows
    represent multiple combinations of covariate values.  For example
    \code{matrix(c(1,2),nrow=2)} if there is only one covariate in the
    model, and we want survival for covariate values of 1 and 2.  A
    vector can also be supplied if just one combination of covariates is
    needed.

    For ``factor'' (categorical) covariates, the values of the contrasts
    representing factor levels (as returned by the
    \code{\link{contrasts}} function) should be used.  For example, for
    a covariate \code{agegroup} specified as an unordered factor with
    levels \code{20-29, 30-39, 40-49, 50-59}, and baseline level
    \code{20-29}, there are three contrasts.  To return summaries for
    groups \code{20-29} and \code{40-49}, supply
    \code{X = rbind(c(0,0,0), c(0,1,0))},
    since all contrasts are zero for the baseline level, and the second
    contrast is ``turned on'' for the third level \code{40-49}.  
  }
  \item{type}{ \code{"survival"} for survival probabilities.

    \code{"cumhaz"} for cumulative hazards.

    \code{"hazard"} for hazards.

    Ignored if \code{"fn"} is specified.
}
  \item{fn}{
    Custom function of the parameters to summarise against time.  This
    has optional first two arguments \code{t} representing time, and
    \code{start}
    representing left-truncation points, and any remaining arguments
    must be parameters of the distribution. 
It should return a vector of the
    same length as \code{t}.
  }
  \item{t}{ Times to calculate fitted values for. By default, these are the
    sorted unique observation (including censoring) times in the
    data - for left-truncated datasets these are the "stop" times.
  }

  \item{start}{ Optional left-truncation time or times.  The returned
  survival, hazard or cumulative hazard will be conditioned on survival
  up to this time.

  A vector of the same length as \code{t} can be supplied to allow
  different truncation times for each prediction time, though this
  doesn't make sense in the usual case where this function is used to
  calculate a predicted trajectory for a single individual.  This is why
  the default \code{start} time was changed for version 0.4 of
  \pkg{flexsurv} - this was previously a vector of the start times
  observed in the data. 
  }

  \item{ci}{Set to \code{FALSE} to omit confidence intervals.}

  \item{B}{Number of simulations from the normal asymptotic distribution
  of the estimates used to calculate confidence intervals.  Decrease
    for greater speed at the expense of accuracy, or set
  \code{B=0} to turn off calculation of CIs.}

  \item{cl}{Width of symmetric confidence intervals, relative to 1.}

  \item{tidy}{If \code{TRUE}, then the results are returned as a tidy
    data frame instead of a list.  This can help with using the
    \pkg{ggplot2} package to compare summaries for different covariate
    values. }
  
  \item{...}{Further arguments passed to or from other methods.
    Currently unused.}
}
\value{
  If \code{tidy=FALSE}, a list with one component for each unique covariate value (if there are
  only categorical covariates) or one component (if there are no
  covariates or any continuous covariates).  Each of these components
  is a matrix with one row for each time in \code{t}, giving the
  estimated survival (or cumulative hazard, or hazard) and 95\%
  confidence limits.  These list components are named with the covariate
  names and values which define them.

  If \code{tidy=TRUE}, a data frame is returned instead.  This is formed
  by stacking the above list components, with additional columns to
  identify the covariate values that each block corresponds to.
  
  If there are multiple summaries, an additional list component named
  \code{X} contains a matrix with the exact values of contrasts (dummy
  covariates) defining each summary.

  The \code{\link{plot.flexsurvreg}} function can be used to quickly
  plot these model-based summaries against empirical summaries such as
  Kaplan-Meier curves, to diagnose model fit.

  Confidence intervals 
  are obtained by random sampling from the asymptotic normal
  distribution of the maximum likelihood estimates (see, e.g. Mandel
  (2013)).  
}
\details{
  Time-dependent covariates are not currently supported.  The covariate
  values are assumed to be constant through time for each fitted curve.
}
\seealso{
  \code{\link{flexsurvreg}}, \code{\link{flexsurvspline}}.
}
\references{
  Mandel, M. (2013). "Simulation based confidence intervals for
  functions with complicated derivatives." The American Statistician (in
  press).
}
\author{C. H. Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}}
\keyword{models}
