% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmixmsm.R
\name{ppath_fmixmsm}
\alias{ppath_fmixmsm}
\title{Probability of each pathway taken through a mixture multi-state model}
\usage{
ppath_fmixmsm(x, newdata = NULL, final = FALSE, B = NULL)
}
\arguments{
\item{x}{Object returned by \code{\link{fmixmsm}}, representing a multi-state
model built from piecing together mixture models fitted by
\code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{final}{If \code{TRUE} then the probabilities of pathways with the same
final state are added together, to produce the probability  of each
ultimate outcome or absorbing state from the multi-state model.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}
}
\value{
Data frame of pathway probabilities by covariate value and pathway.
}
\description{
Probability of each pathway taken through a mixture multi-state model
}
