% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexsurvcure.R
\name{flexsurvcure}
\alias{flexsurvcure}
\title{Mixture and Non-Mixture Parametric Cure Models}
\usage{
flexsurvcure(formula, data, weights, bhazard, subset, dist, na.action,
  link = "logistic", mixture = T, ...)
}
\arguments{
\item{formula}{A formula expression in conventional R linear modeling
syntax. The response must be a survival object as returned by the
\code{\link{Surv}} function, and any covariates are given on the right-hand
side.  For example,

\code{Surv(time, dead) ~ age + sex}

\code{Surv} objects of \code{type="right"},\code{"counting"},
\code{"interval1"} or \code{"interval2"} are supported, corresponding to
right-censored, left-truncated or interval-censored observations.

If there are no covariates, specify \code{1} on the right hand side, for
example \code{Surv(time, dead) ~ 1}.

By default, covariates are placed on the ``theta'' parameter of the
distribution, representing the cure fraction, through a linear
model with the selected link function.

Covariates can be placed on parameters of the base distribution by using the
name of the parameter as a ``function'' in the formula.  For example, in a
Weibull model, the following expresses the scale parameter in terms of age
and a treatment variable \code{treat}, and the shape parameter in terms of
sex and treatment.

\code{Surv(time, dead) ~ age + treat + shape(sex) + shape(treat)}

However, if the names of the ancillary parameters clash with any real
functions that might be used in formulae (such as \code{I()}, or
\code{factor()}), then those functions will not work in the formula.  A
safer way to model covariates on ancillary parameters is through the
\code{anc} argument to \code{\link{flexsurvreg}}.

\code{\link{survreg}} users should also note that the function
\code{strata()} is ignored, so that any covariates surrounded by
\code{strata()} are applied to the location parameter.}

\item{data}{A data frame in which to find variables supplied in
\code{formula}.  If not given, the variables should be in the working
environment.}

\item{weights}{Optional variable giving case weights.}

\item{bhazard}{Optional variable giving expected hazards for relative
survival models.}

\item{subset}{Vector of integers or logicals specifying the subset of the
observations to be used in the fit.}

\item{dist}{A string representing one of the built-in distributions of flexsurv.
\code{Surv(time, dead) ~ age + treat, anc = list(shape = ~ sex + treat)}}

\item{na.action}{a missing-data filter function, applied after any 'subset'
argument has been used. Default is \code{options()$na.action}.}

\item{link}{A string representing the link function to use for estimation of the
cure fraction.  Defaults to logistic.}

\item{mixture}{optional TRUE/FALSE to specify whether a mixture model should be fitted.  Defaults to TRUE.}

\item{...}{other arguments to be passed to \code{\link{flexsurvreg}}.}
}
\description{
Mixture and non-mixture cure models using flexible base distributions
from the flexsurv package.
}
\details{
This function works as a wrapper around \code{\link{flexsurvreg}} by
dynamically constructing a custom distribution using wrappers to the
pdf and cdf functions.

In a parametric mixture model, it is assumed that there exists a group of individuals
who experience no excess mortality, with the proportion of such individuals being given
by the cure fraction parameter, and a parametric distribution representing the excess
mortality for the remaining individuals.

By contrast, a parametric non-mixture model simply rescales an existing parametric
distribution such that the probability of survival asymptotically approaches the
cure fraction parameter as time approaches infinity.
}
\examples{
flexsurvcure(Surv(rectime,censrec)~group, data=bc, dist="weibull", anc=list(scale=~group))
flexsurvcure(Surv(rectime,censrec)~group, data=bc, dist="lnorm", mixture = FALSE)
flexsurvcure(Surv(rectime,censrec)~group, data=bc, dist="weibull", link="loglog")
}
