% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_header_footer}
\alias{add_header_footer}
\alias{add_header}
\alias{add_footer}
\title{Add a row of labels in header or footer part}
\usage{
add_header(x, top = TRUE, ...)

add_footer(x, top = TRUE, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{top}{should the row be inserted at the top or the bottom.}

\item{...}{a named list (names are data colnames) of strings
specifying corresponding labels to add.}
}
\description{
Add a single row of labels in the flextable's header
or footer part. It can be inserted at the top or the bottom of the part.
}
\examples{
ft <- flextable( head( iris ),
  col_keys = c("Species", "Sepal.Length", "Petal.Length", "Sepal.Width", "Petal.Width") )
ft <- add_header(x = ft, Sepal.Length = "length",
  Sepal.Width = "width", Petal.Length = "length",
  Petal.Width = "width", Species = "Species", top = FALSE )
ft <- add_header(ft, Sepal.Length = "Inches",
  Sepal.Width = "Inches", Petal.Length = "Inches",
  Petal.Width = "Inches", Species = "Species", top = TRUE )
ft <- merge_h(ft, part = "header")
ft <- add_footer(ft, Species = "This is a footnote" )
ft <- merge_at(ft, j = 1:5, part = "footer")
ft
}
