% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{hline}
\alias{hline}
\title{set horizontal borders}
\usage{
hline(x, i = NULL, j = NULL, border = NULL, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{border}{border defined by a call to \code{\link[officer]{fp_border}}}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
The function is applying an horizontal border to inner
content of one or all parts of a flextable. The lines are the
bottom borders of selected cells.
}
\examples{
library(officer)
std_border = fp_border(color="gray")

ft <- flextable(head(iris))
ft <- border_remove(x = ft)

# add horizontal borders
ft <- hline(ft, part="all", border = std_border )
ft
}
\seealso{
Other borders management: \code{\link{border_inner_h}},
  \code{\link{border_inner_v}}, \code{\link{border_outer}},
  \code{\link{border_remove}}, \code{\link{border}},
  \code{\link{hline_bottom}}, \code{\link{hline_top}},
  \code{\link{vline_left}}, \code{\link{vline_right}},
  \code{\link{vline}}
}
\concept{borders management}
