% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{linerange}
\alias{linerange}
\title{mini linerange chunk wrapper}
\usage{
linerange(value, min = NULL, max = NULL, rangecol = "#CCCCCC",
  stickcol = "#FF0000", bg = "transparent", width = 1,
  height = 0.2, raster_width = 30)
}
\arguments{
\item{value}{values containing the bar size}

\item{min}{min bar size. Default min of value}

\item{max}{max bar size. Default max of value}

\item{rangecol}{bar color}

\item{stickcol}{jauge color}

\item{bg}{background color}

\item{width, height}{size of the resulting png file in inches}

\item{raster_width}{number of pixels used as width
when interpolating value.}
}
\description{
This function is used to insert lineranges into
flextable with function \code{\link{compose}}.
It should be used inside a call to \code{\link{as_paragraph}}
}
\note{
PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
myft <- flextable( head(iris, n = 10 ))

myft <- compose( myft, j = 1,
  value = as_paragraph(
    linerange(value = Sepal.Length)
  ),
  part = "body")

autofit(myft)
}
\seealso{
\code{\link{compose}}, \code{\link{as_paragraph}}

Other chunk elements for paragraph: \code{\link{as_bracket}},
  \code{\link{as_b}}, \code{\link{as_chunk}},
  \code{\link{as_image}}, \code{\link{as_i}},
  \code{\link{as_sub}}, \code{\link{as_sup}},
  \code{\link{hyperlink_text}}, \code{\link{minibar}}
}
\concept{chunk elements for paragraph}
