% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_none}
\alias{merge_none}
\title{Delete flextable merging informations}
\usage{
merge_none(x, part = "all")
}
\arguments{
\item{x}{\code{flextable} object}

\item{part}{partname of the table where merge has to be done.}
}
\description{
Delete all merging informations from a flextable.
}
\examples{
typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width", "Species" ),
  what = c("Sepal", "Sepal", "Petal", "Petal", "Species"),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )

ft <- flextable( head( iris ) )
ft <- set_header_df(ft, mapping = typology, key = "col_keys" )
ft <- merge_v(ft, j = c("Species"))

ft <- theme_tron_legacy( merge_none( ft ) )
ft
}
\seealso{
Other flextable merging function: 
\code{\link{merge_at}()},
\code{\link{merge_h_range}()},
\code{\link{merge_h}()},
\code{\link{merge_v}()}
}
\concept{flextable merging function}
