% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{knit_print.flextable}
\alias{knit_print.flextable}
\title{Render flextable in rmarkdown}
\usage{
\method{knit_print}{flextable}(x, ...)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{...}{further arguments, not used.}
}
\description{
Function used to render flextable in knitr/rmarkdown documents.

You should not call this method directly. This function is used by the knitr
package to automatically display a flextable in an "R Markdown" document from
a chunk. However, it is recommended to read its documentation in order to get
familiar with the different options available.
\if{html}{\figure{fig_formats.png}{options: width=200px}} HTML, Word, PowerPoint and PDF outputs are supported.

Table captioning is a flextable feature compatible with R Markdown
documents. The feature is available for HTML, PDF and Word documents.
Compatibility with the "bookdown" package is also ensured, including the
ability to produce captions so that they can be used in cross-referencing.
}
\note{
Supported formats require some
minimum \href{https://pandoc.org/installing.html}{pandoc} versions:

\tabular{rc}{
\strong{Output format} \tab \strong{pandoc minimal version} \cr
HTML              \tab >= 1.12\cr
Word (docx)       \tab >= 2.0 \cr
PowerPoint (pptx) \tab >= 2.4 \cr
PDF               \tab >= 1.12
}
}
\section{Chunk options}{


Some features, often specific to an output format, are available to help you
configure some global settings relatve to the table output. knitr's chunk options
are to be used to change the default settings:

\tabular{lcccccc}{
\strong{chunk option} \tab \strong{property} \tab \strong{default value} \tab \strong{HTML} \tab \strong{docx} \tab \strong{PDF} \tab \strong{pptx} \cr
ft.align        \tab flextable alignment, supported values are 'left', 'center' and 'right'    \tab 'center' \tab yes \tab yes \tab yes \tab no \cr
ft.split        \tab Word option 'Allow row to break across pages' can be activated when TRUE. \tab FALSE    \tab no  \tab yes \tab no  \tab no \cr
ft.tabcolsep    \tab space between the text and the left/right border of its containing cell   \tab 8.0      \tab no  \tab no  \tab yes \tab no \cr
ft.arraystretch \tab height of each row relative to its default height                         \tab 1.5      \tab no  \tab no  \tab yes \tab no \cr
ft.left         \tab left coordinates in inches                                                \tab 1.0      \tab no  \tab no  \tab no  \tab yes\cr
ft.top          \tab top coordinates in inches                                                 \tab 2.0      \tab no  \tab no  \tab no  \tab yes
}
}

\section{Table caption}{


Captions can be defined in two ways.

The first is with the \code{set_caption} function. If it is used,
the other method will be ignored. The second method is by using
knitr chunk option \code{tab.cap}.\preformatted{set_caption(x, caption = "my caption")
}

If \code{set_caption} function is not used, caption identifier will be
read from knitr's chunk option \code{tab.id} or \code{label} if in a bookdown
(this is to respect the bookdown standards).

\code{tab.id='my_id'} or \code{label='my_id'}

Word output provide more options such as ability to choose the prefix for numbering chunk for
example. The table below expose these options:

\tabular{llll}{
\strong{chunk option} \tab \strong{purpose} \tab \strong{rmarkdown} \tab \strong{bookdown} \cr
tab.cap.style \tab (Word only) style name to use for table captions            \tab yes \tab yes\cr
tab.cap.pre   \tab (Word only) Prefix for numbering chunk (default to "Table") \tab yes \tab yes\cr
tab.cap.sep   \tab (Word only) Suffix for numbering chunk (default to ": ")    \tab yes \tab yes\cr
tab.cap       \tab \strong{Caption label}                                      \tab yes \tab yes\cr
tab.id        \tab \strong{Caption reference unique identifier}                \tab yes \tab no \cr
label         \tab \strong{Caption reference unique identifier}                \tab no  \tab yes
}
}

\section{PDF output}{


Some features are not implemented in PDF due to technical
infeasibility. These are the padding, line_spacing and
height properties.
}

\section{PowerPoint output}{


Auto-adjust Layout is not available for PowerPoint.

Also images cannot be integrated into tables with the PowerPoint format.
}

\examples{

# simple examples -----
demo_docx <- system.file(package = "flextable", "examples/rmd", "demo.Rmd")
rmd_file <- tempfile(fileext = ".Rmd")
file.copy(demo_docx, to = rmd_file, overwrite = TRUE)
rmd_file # R Markdown document used for demo
if(require("rmarkdown", quietly = TRUE)){
#  knitr::opts_chunk$set(webshot = "webshot2")
#  render(input = rmd_file, output_format = "word_document", output_file = "doc.docx")
#  render(input = rmd_file, output_format = "pdf_document", output_file = "doc.pdf")
#  render(input = rmd_file, output_format = "html_document", output_file = "doc.html")
#  render(input = rmd_file, output_format = "powerpoint_presentation", output_file = "pres.pptx")
#  render(input = rmd_file, output_format = "slidy_presentation", output_file = "slidy.html")
#  render(input = rmd_file, output_format = "beamer_presentation", output_file = "beamer.pdf")
#  render(input = rmd_file, output_format = "pagedown::html_paged", output_file = "paged.html")
}


## bookdown examples wth captions and cross ref -----
# captions_example <- system.file(
#   package = "flextable",
#   "examples/rmd", "captions_example.Rmd")
#
# dir_tmp <- tempfile(pattern = "dir")
# dir.create(dir_tmp, showWarnings = FALSE, recursive = TRUE)
# file.copy(captions_example, dir_tmp)
# rmd_file <- file.path(dir_tmp, basename(captions_example))
#
# file.copy(captions_example, to = rmd_file, overwrite = TRUE)
#
# if(require("rmarkdown", quietly = TRUE)){
#   render(input = rmd_file,
#          output_format = word_document(),
#          output_file = "doc.docx")
#   render(input = rmd_file,
#          output_format = pdf_document(latex_engine = "xelatex"),
#          output_file = "doc.pdf")
#   render(input = rmd_file,
#          output_format = html_document(),
#          output_file = "doc.html")
#
#   # bookdown ----
#   if(require("bookdown", quietly = TRUE)){
#     render(input = rmd_file, output_format = word_document2(),
#            output_file = "book.docx")
#     render(input = rmd_file,
#            output_format = pdf_document2(latex_engine = "xelatex"),
#            output_file = "book.pdf")
#     render(input = rmd_file,
#            output_format = html_document2(),
#            output_file = "book.html")
#
#     # officedown ----
#     if(require("officedown", quietly = TRUE)){
#       render(input = rmd_file,
#              output_format = markdown_document2(base_format=rdocx_document),
#              output_file = "officedown.docx")
#     }
#   }
# }
# browseURL(dirname(rmd_file))


}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{flextable_to_rmd}()},
\code{\link{htmltools_value}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
