% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_header_row}
\alias{add_header_row}
\alias{add_footer_row}
\title{Add labels and merge cells in a new header or footer row}
\usage{
add_header_row(x, top = TRUE, values = character(0), colwidths = integer(0))

add_footer_row(x, top = TRUE, values = character(0), colwidths = integer(0))
}
\arguments{
\item{x}{a \code{flextable} object}

\item{top}{should the row be inserted at the top or the bottom.}

\item{values}{values to add as a character vector}

\item{colwidths}{the number of columns to merge in the row for each label}
}
\description{
Add an header or footer new row where some cells are merged,
labels are associated with a number of columns to merge. The function
is row oriented. One call allow to add one single row.
}
\section{Illustrations}{


\if{html}{\figure{fig_add_header_row_1.png}{options: width="400"}}
}

\examples{
ft <- flextable( head( iris ) )
ft <- add_header_row(ft, values = "blah blah", colwidths = 5)
ft <- add_header_row(ft, values = c("blah", "blah"), colwidths = c(3,2))
ft <- theme_tron(ft)
ft
ft <- flextable( head( iris ) )
ft <- add_footer_row(ft, values = "blah blah", colwidths = 5)
ft <- add_footer_row(ft, values = c("blah", "blah"), colwidths = c(3,2))
ft
}
\seealso{
Other headers and footers: 
\code{\link{add_header_lines}()},
\code{\link{add_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{headers and footers}
