% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_equation}
\alias{as_equation}
\title{equation chunk}
\usage{
as_equation(x, width = 1, height = 0.2, unit = "in")
}
\arguments{
\item{x}{values containing the 'MathJax' equations}

\item{width, height}{size of the resulting equation in inches}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}
}
\description{
This function is used to insert equations into
flextable with function \code{\link[=compose]{compose()}}.
It should be used inside a call to \code{\link[=as_paragraph]{as_paragraph()}}.

To use this function, package 'equatags' is required;
also \code{equatags::mathjax_install()} must be executed only once
to install necessary dependencies.
}
\examples{
library(flextable)
if(require("equatags") && mathjax_available()){

eqs <- c(
  "(ax^2 + bx + c = 0)",
  "a \\\\ne 0",
  "x = {-b \\\\pm \\\\sqrt{b^2-4ac} \\\\over 2a}")
df <- data.frame(formula = eqs)
df


ft <- flextable(df)
ft <- compose(
  x = ft, j = "formula",
  value = as_paragraph(as_equation(formula, width = 2, height = .5)))
ft <- align(ft, align = "center", part = "all")
ft <- width(ft, width = 2)
ft

}
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
