% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{as_image}
\alias{as_image}
\title{image chunk wrapper}
\usage{
as_image(src, width = 0.5, height = 0.2, unit = "in", ...)
}
\arguments{
\item{src}{image filename}

\item{width, height}{size of the png file in inches}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{...}{unused argument}
}
\description{
The function lets add images within flextable
objects with function \code{\link[=compose]{compose()}}.
It should be used inside a call to \code{\link[=as_paragraph]{as_paragraph()}}.
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\section{Illustrations}{


\if{html}{\figure{fig_as_image_1.png}{options: width="400"}}
}

\examples{
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
library(officer)

myft <- flextable( head(iris))

myft <- compose( myft, i = 1:3, j = 1,
 value = as_paragraph(
   as_image(src = img.file, width = .20, height = .15),
   " blah blah ",
   as_chunk(Sepal.Length, props = fp_text(color = "red"))
 ),
 part = "body")

ft <- autofit(myft)
ft
}
\seealso{
\code{\link[=compose]{compose()}}, \code{\link[=as_paragraph]{as_paragraph()}}

Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
