% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.grouped_data}
\alias{as_flextable.grouped_data}
\title{tabular summary for grouped_data object}
\usage{
\method{as_flextable}{grouped_data}(x, col_keys = NULL, hide_grouplabel = FALSE, ...)
}
\arguments{
\item{x}{object to be transformed as flextable}

\item{col_keys}{columns names/keys to display. If some column names are not in
the dataset, they will be added as blank columns by default.}

\item{hide_grouplabel}{if TRUE, group label will not be rendered, only
level/value will be rendered.}

\item{...}{unused argument}
}
\description{
produce a flextable from a table
produced by function \code{\link[=as_grouped_data]{as_grouped_data()}}.
}
\section{Illustrations}{


\if{html}{\figure{fig_as_flextable.grouped_data_1.png}{options: width="400"}}
}

\examples{
library(data.table)
CO2 <- CO2
setDT(CO2)
CO2$conc <- as.integer(CO2$conc)

data_co2 <- dcast(CO2, Treatment + conc ~ Type,
                  value.var = "uptake", fun.aggregate = mean)
data_co2 <- as_grouped_data(x = data_co2, groups = c("Treatment"))

ft <- as_flextable( data_co2 )
ft <- add_footer_lines(ft, "dataset CO2 has been used for this flextable")
ft <- add_header_lines(ft, "mean of carbon dioxide uptake in grass plants")
ft <- set_header_labels(ft, conc = "Concentration")
ft <- autofit(ft)
ft <- width(ft, width = c(1, 1, 1))
ft
}
\seealso{
\code{\link[=as_grouped_data]{as_grouped_data()}}

Other as_flextable methods: 
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
