% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{color}
\alias{color}
\title{Set font color}
\usage{
color(x, i = NULL, j = NULL, color, part = "body", source = j)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{color}{color to use as font color. If a function, function need to return
a character vector of colors.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}

\item{source}{if color is a function, source is specifying the dataset column to be used
as argument to \code{color}. This is only useful if j is colored with values contained in
other columns.}
}
\description{
Change text color of selected rows and
columns of a flextable. A function can be used instead of
fixed colors.

When \code{color} is a function, it is possible to color cells based on values
located in other columns, using hidden columns (those not used by
argument \code{colkeys}) is a common use case. The argument \code{source}
has to be used to define what are the columns to be used for the color
definition and the argument \code{j} has to be used to define where to apply
the colors and only accept values from \code{colkeys}.
}
\examples{
ft <- flextable(head(mtcars))
ft <- color(ft, color = "orange", part = "header")
ft <- color(ft,
  color = "red",
  i = ~ qsec < 18 & vs < 1
)
ft

if (require("scales")) {
  scale <- scales::col_numeric(domain = c(-1, 1), palette = "RdBu")
  x <- as.data.frame(cor(iris[-5]))
  x <- cbind(
    data.frame(
      colname = colnames(x),
      stringsAsFactors = FALSE
    ),
    x
  )

  ft_2 <- flextable(x)
  ft_2 <- color(ft_2, j = x$colname, color = scale)
  ft_2 <- set_formatter_type(ft_2)
  ft_2
}
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{font}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
