% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{set_table_properties}
\alias{set_table_properties}
\title{Global table properties}
\usage{
set_table_properties(
  x,
  layout = "fixed",
  width = 0,
  align = "center",
  opts_html = list(),
  opts_word = list(),
  opts_pdf = list(),
  word_title = NULL,
  word_description = NULL
)
}
\arguments{
\item{x}{flextable object}

\item{layout}{'autofit' or 'fixed' algorithm. Default to 'autofit'.}

\item{width}{The parameter has a different effect depending on the
output format. Users should consider it as a minimum width.
In HTML, it is the minimum width of the space that the
table should occupy. In Word, it is a preferred size and Word
may decide not to strictly stick to it. It has no effect on
PowerPoint and PDF output. Its default value is 0, as an effect, it
only use necessary width to display all content. It is not used by the
PDF output.}

\item{align}{alignment in document (only Word, HTML and PDF),
supported values are 'left', 'center' and 'right'.}

\item{opts_html}{html options as a list. Supported elements are:
\itemize{
\item 'shadow' \code{TRUE} or \code{FALSE}, use shadow dom, this option is existing
to disable shadow dom (set to \code{FALSE}) for pagedown and Quarto that can
not support it for now.
\item 'extra_css': extra css instructions to be integrated with the HTML
code of the table.
\item 'scroll': NULL or a list if you want to add a scroll-box.
\itemize{
\item Use an empty list to add an horizontal scroll.  The with
is fixed, corresponding to the container's width.
\item If the list has a value named \code{height} it will be used as
height and the scroll will happen also vertically. The height
will be in pixel if numeric, if a string it should be a valid css
measure.
\item If the list has a value named \code{freeze_first_column} set to \code{TRUE},
the first column is set as a \emph{sticky} column.
\item If the list has a value named \code{add_css} it will be used as extra
css to add, .i.e: \verb{border:1px solid red;}.
}
}}

\item{opts_word}{Word options as a list. Supported elements are:
\itemize{
\item 'split':  Word option 'Allow row to break across pages' can be
activated when TRUE.
\item 'keep_with_next': Word option 'keep rows together' is
activated when TRUE. It avoids page break within tables. This
is handy for small tables, i.e. less than a page height.
}}

\item{opts_pdf}{PDF options as a list. Supported elements are:
\itemize{
\item 'tabcolsep': space between the text and the left/right border of its containing
cell.
\item 'arraystretch': height of each row relative to its default
height, the default value is 1.5.
\item 'float': type of floating placement in the PDF document, one of:
\itemize{
\item 'none' (the default value), table is placed after the preceding
paragraph.
\item 'float', table can float to a place in the text where it fits best
\item 'wrap-r', wrap text around the table positioned to the right side of the text
\item 'wrap-l', wrap text around the table positioned to the left side of the text
\item 'wrap-i', wrap text around the table positioned inside edge-near the binding
\item 'wrap-o', wrap text around the table positioned outside edge-far from the binding
}
\item 'fonts_ignore': if TRUE, pdf-engine 'pdflatex' can be used instead of
'xelatex' or 'lualatex.' If pdflatex is used, fonts will be ignored because they are
not supported by pdflatex, whereas with the xelatex and lualatex engines they are.
\item 'default_line_color': default line color, restored globally after the flextable is produced.
}}

\item{word_title}{alternative text for Word table (used as title of the table)}

\item{word_description}{alternative text for Word table (used as description of the table)}
}
\description{
Set table layout and table width. Default to fixed
algorithm.

If layout is fixed, column widths will be used to display the table;
\code{width} is ignored.

If layout is autofit, column widths will not be used;
table width is used (as a percentage).
}
\note{
PowerPoint output ignore 'autofit layout'.
}
\examples{
library(flextable)
ft_1 <- flextable(head(cars))
ft_1 <- autofit(ft_1)
ft_2 <- set_table_properties(ft_1, width = .5, layout = "autofit")
ft_2
ft_3 <- set_table_properties(ft_1, width = 1, layout = "autofit")

# add scroll for HTML ----
set.seed(2)
dat <- lapply(1:14, function(x) rnorm(n = 20))
dat <- setNames(dat, paste0("colname", 1:14))
dat <- as.data.frame(dat)

ft_4 <- flextable(dat)
ft_4 <- colformat_double(ft_4)
ft_4 <- bg(ft_4, j = 1, bg = "#DDDDDD", part = "all")
ft_4 <- bg(ft_4, i = 1, bg = "#DDDDDD", part = "header")
ft_4 <- autofit(ft_4)
ft_4 <- set_table_properties(
  x = ft_4,
  opts_html = list(
    shadow = FALSE,
    scroll = list(
      height = "500px",
      freeze_first_column = TRUE
    )
  )
)
ft_4
}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
