% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.r
\docType{methods}
\name{solve}
\alias{solve}
\alias{solve,float32-method}
\title{solve}
\usage{
\S4method{solve}{float32}(a, b, ...)
}
\arguments{
\item{a, b}{A float vector/matrix.}

\item{...}{Ignored.}
}
\value{
A float matrix if inverting.  If solving a system, a float vector if given
one "right hand side", and a float matrix otherwise (just like R).
}
\description{
Solve a system of equations or invert a float matrix.
}
\examples{
library(float)

s = flrunif(10, 3)
cp = crossprod(s)
solve(cp)

y = fl(1:3)
solve(cp, y)

}
