% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\alias{get_status}
\alias{get_status.flow}
\alias{get_status.character}
\alias{get_status.data.frame}
\title{Monitor status of flow(s)}
\usage{
status(
  x,
  use_cache = FALSE,
  verbose = opts_flow$get("verbose"),
  out_format = "markdown",
  ...
)

get_status(x, ...)

\method{get_status}{flow}(x, verbose, use_cache, out_format, ...)

\method{get_status}{character}(x, verbose, use_cache, out_format, ...)

\method{get_status}{data.frame}(x, verbose, use_cache, progress = TRUE, ...)
}
\arguments{
\item{x}{path to the flow root folder or a parent folder to summarize several flows.}

\item{use_cache}{This skips checking status of jobs which have already been completed a
and assumes no new jobs were submitted in the flow(s) being monitored. [FALSE]}

\item{verbose}{A numeric value indicating the amount of messages to produce.
 Values are integers varying from 0, 1, 2, 3, .... Please refer to the \link{verbose} page for more details.
\code{opts_flow$get("verbose")}}

\item{out_format}{passed onto knitr:::kable. supports: markdown, rst, html... [markdown]}

\item{...}{not used}

\item{progress}{Whether or not to show a progress bar, when fetching/reading files [TRUE]}
}
\description{
Summarize status of a flow OR multiple flows OR a high-level summary of all flows in a folder.
}
\details{
basename(x) is used in a wild card search.

\itemize{
  \item Get status of all the flows: 
  (all flows with 'sleep_pipe' in their name are checked and their status is shown)
  <br>
  \code{flowr status x=~/flowr/runs/sleep_pipe*}
  \item Provide a high level summary of ALL flows in a folder:
  <br>
   \code{flowr status x=~/flowr/runs}
}

Use \strong{use_cache}=TRUE to speed up checking the status. 
This assumes that no new jobs have been submitted and skips (re-)checking status of 
completed jobs.

Once all the jobs have been submitted to the cluster you may always use \code{use_cache=TRUE}.
}
\examples{
\dontrun{
status(x = "~/flowr/runs/sleep_pipe*")
## an example for running from terminal
flowr status x=path_to_flow_directory
}
}
