% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class-def.R
\name{flow}
\alias{flow}
\title{Flow constructor}
\usage{
flow(jobs = list(new("job")), name = "newflow", desc = "my_super_flow",
  mode = c("scheduler", "trigger", "R"), flow_base_path = "~/flows",
  trigger_path = "", flow_path = "", status = "")
}
\arguments{
\item{jobs}{\code{list} A list of jobs to be included in this flow}

\item{name}{\code{character} Name of the flow. Defaults to \code{'newname'}
Used in \link{submit_flow} to name the working directories.}

\item{desc}{\code{character} Description of the flow
This is used to name folders (when submitting jobs, see \link{submit_flow}).
It is good practice to avoid spaces and other special characters.
An underscore '_' seems like a good word separator.
Defaults to 'my_super_flow'. We usually use this to put sample names of the data.}

\item{mode}{\code{character} Mode of submission of the flow.}

\item{flow_base_path}{The base path of all the flows you would submit.
Defaults to \code{~/flows}. Best practice to ignore it.}

\item{trigger_path}{\code{character}
Defaults to \code{~/flows/trigger}. Best practice to ignore it.}

\item{flow_path}{\code{character}}

\item{status}{\code{character} Not used at this time}
}
\description{
Flow constructor
}
\examples{
cmds = rep("sleep 5", 10)
qobj <- queue(type='torque')
## run the 10 commands in parallel
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter", name = "job1")

## run the 10 commands sequentially, but WAIT for the previous job to complete
## Many-To-One
jobj2 <- job(q_obj=qobj, cmd = cmds, submission_type = "serial",
 dependency_type = "gather", previous_job = "job1", name = "job2")

## As soon as first job on 'job1' is complete
## One-To-One
jobj3 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter",
 dependency_type = "serial", previous_job = "job1", name = "job3")

fobj <- flow(jobs = list(jobj1, jobj2, jobj3))

## plot the flow
plot_flow(fobj)
\dontrun{
## dry run, only create the structure without submitting jobs
submit_flow(fobj)

## execute the jobs: ONLY works on computing cluster, would fail otherwise
submit_flow(fobj, execute = TRUE)
}
}

