% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class-def.R
\name{queue}
\alias{queue}
\title{Create a \code{queue} object which containg details about how a job is submitted.}
\usage{
queue(object, submit_exe, queue = "long", nodes = 1, cpu = 1,
  dependency = list(), jobname = "name", walltime, cwd = "~/flows",
  memory, stderr = "~/flows/tmp", stdout = "~/flows",
  email = Sys.getenv("USER"), type = c("lsf", "torque", "sge"),
  format = "", extra_opts = "", verbose = TRUE, server = "localhost",
  ...)
}
\arguments{
\item{object}{this is not used currenlty, ignore.}

\item{submit_exe}{the exact command used to submit jobs to the cluster example \code{qsub}
\code{bsub} etc.}

\item{queue}{the type of queue your group usually uses}

\item{nodes}{number of nodes you would like to request. \emph{optional} [Used by class job]}

\item{cpu}{number of cpus you would like to reserve [Used by class job]}

\item{dependency}{a list of jobs to complete before starting this one [Used by class job]}

\item{jobname}{name of this job in the computing cluster [Used by class job]}

\item{walltime}{max walltime of a job. [Used by class job]}

\item{cwd}{[Used by class job]}

\item{memory}{The amount of memory reserved. Units depend on the platform used to process jobs}

\item{stderr}{[Used by class job]}

\item{stdout}{[Used by class job]}

\item{email}{[Used by class job]}

\item{type}{Required and important. Currently supported values are 'lsf' and 'torque'. [Used by class job]}

\item{format}{We have a default format for the final command line string generated for 'lsf' and 'torque'.
This defined the exact (\code{bsub}/\code{qsub}) used to submit the job. One of the most important features required is:
dependencies. More on them here:}

\item{extra_opts}{[Used by class job]}

\item{verbose}{[logical] TRUE/FALSE}

\item{server}{This is not implemented currently. This would specify the head node of the computing cluster. At this time submission needs to be done on the head node of the cluster where flow is to be submitted}

\item{...}{other passed onto object creation. Example: memory, walltime, cpu}
}
\description{
This function defines the queue used to submit jobs to the cluster. In essence details about the
computing cluster in use.
}
\examples{
qobj <- queue(type='lsf')
}
\keyword{queue}

