% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_FLPS.r
\name{runFLPS}
\alias{runFLPS}
\title{Conduct fully latent principal stratification}
\usage{
runFLPS(
  inp_data = NULL,
  custom_data = NULL,
  custom_stan = NULL,
  outcome = NULL,
  group = NULL,
  covariate = NULL,
  lv_model = NULL,
  lv_type = NULL,
  priors_input = NULL,
  stan_options = list(),
  ...
)
}
\arguments{
\item{inp_data}{A matrix or a data frame}

\item{custom_data}{A list. should be provided with \code{custom_stan}.}

\item{custom_stan}{A string. should be provided with \code{custom_data}.}

\item{outcome}{A character indicating the name of an outcome variable}

\item{group}{A character indicating the name of a treatment/control group variable}

\item{covariate}{A character indicating the names of covariate variables}

\item{lv_model}{A description of the latent variable model, which is similar
to the \pkg{lavaan} model syntax.
 \itemize{
   \item \code{=~} : Specify the association between factors and indicators (e.g., F1 =~ v1 + v2 + v3).
   \item \code{+} : Specify a series of indicators
}}

\item{lv_type}{A character indicating the type of latent variable models}

\item{priors_input}{A list of priors. Otherwise, the default priors are used (N(0, 5). It takes three parameter names including \code{tau0}, \code{tau1}, and \code{omega}, which are the difference between groups, the principal effects, and the effect of latent factors on the outcome. If added, the length of \code{tau1} and \code{omega} must be matched with the number of factors.
Examples of How to specify priors as follows:
 \itemize{
   \item \code{list(tau0 = c(0, 1), tau1 = c(0.5, 1))} : The first element is the mean and the second is the variance of normal priors.
   \item \code{list(tau1 = list(c(0.5, 1), c(-0.4, 1))} : If there's two factors.
}}

\item{stan_options}{A list containing [rstan::stan()] options, using 'name = value'.}

\item{...}{Additional arguments for latent variable models information (e.g., nclass = 2).}
}
\value{
an object of class \code{flps} which contains a \code{\link[rstan]{stanfit}} object.

 \item{call}{argument calls}
 \item{inp_data}{A given data frame}
 \item{flps_model}{a Stan syntax used in [rstan::stan()]}
 \item{flps_data}{a list of data used in [rstan::stan()]}
 \item{flps_fit}{\code{\link[rstan]{stanfit}}}
 \item{time}{a numeric of timing}
}
\description{
Conduct fully latent principal stratification
}
\examples{
\donttest{
inp_data <- flps::makeInpData(
  N       = 200,
  R2Y     = 0.2,
  R2eta   = 0.5,
  omega   = 0.2,
  tau0    = 0.23,
  tau1    = -0.16,
  betaL   = 0.1,
  betaY   = 0.2,
  lambda  = 0.8,
  nitem    = 10,
  nfac    = 1,
  lvmodel = 'rasch' )

res <- runFLPS(
   inp_data = inp_data,
   outcome = "Y",
   group = "Z",
   covariate = c("X1"),
   lv_type = "rasch",
   lv_model = "F =~ v1 + v2 + v3 + v4 + v5 + v6 + v7 + v8 + v9 + v10",
   stan_options = list(iter = 1000, warmup = 500, cores = 1, chains = 2)
   )
}

}
\seealso{
[rstan::stan()]
}
\concept{rstan}
