% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality.R
\name{flux_quality}
\alias{flux_quality}
\title{Assessing the quality of the fits}
\usage{
flux_quality(
  slopes_df,
  f_conc = f_conc,
  f_fluxid = f_fluxid,
  f_slope = f_slope,
  f_time = f_time,
  f_start = f_start,
  f_end = f_end,
  f_fit = f_fit,
  f_cut = f_cut,
  f_pvalue = f_pvalue,
  f_rsquared = f_rsquared,
  f_slope_lm = f_slope_lm,
  f_fit_lm = f_fit_lm,
  f_b = f_b,
  force_discard = c(),
  force_ok = c(),
  force_zero = c(),
  force_lm = c(),
  force_exp = c(),
  ratio_threshold = 0,
  gfactor_threshold = 10,
  fit_type = c(),
  ambient_conc = 421,
  error = 100,
  pvalue_threshold = 0.3,
  rsquared_threshold = 0.7,
  rmse_threshold = 25,
  cor_threshold = 0.5,
  b_threshold = 1,
  cut_arg = "cut",
  instr_error = 5,
  kappamax = FALSE
)
}
\arguments{
\item{slopes_df}{dataset containing slopes}

\item{f_conc}{column containing the measured gas concentration
(exponential fits)}

\item{f_fluxid}{column containing unique IDs for each flux}

\item{f_slope}{column containing the slope of each flux
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{f_time}{column containing the time of each measurement in seconds
(exponential fits)}

\item{f_start}{column with datetime of the start of the measurement
(after cuts)}

\item{f_end}{column with datetime of the end of the measurement
(after cuts)}

\item{f_fit}{column containing the modeled data (exponential fits)}

\item{f_cut}{column containing the cutting information}

\item{f_pvalue}{column containing the p-value of each flux
(linear and quadratic fits)}

\item{f_rsquared}{column containing the r squared of each flux
(linear and quadratic fits)}

\item{f_slope_lm}{column containing the linear slope of each flux
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{f_fit_lm}{column with the fit of the linear model.
(as calculated by the \link[fluxible:flux_fitting]{flux_fitting} function)}

\item{f_b}{column containing the b parameter of the exponential expression
(exponential fits)}

\item{force_discard}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{force_zero}{vector of fluxIDs that should be replaced by zero by
the user's decision}

\item{force_lm}{vector of fluxIDs for which the linear slope should be used
by the user's decision}

\item{force_exp}{vector of fluxIDs for which the exponential slope should be
used by the user's decision (kappamax method)}

\item{ratio_threshold}{ratio of gas concentration data points over length of
measurement (in seconds) below which the measurement will be considered as
not having enough data points to be considered for calculations}

\item{gfactor_threshold}{threshold for the g-factor. Defines a window
with its opposite outside which the flux will be flagged \code{discard}
(exponential quadratic fits).}

\item{fit_type}{model fitted to the data, linear, quadratic or exponential.
Will be automatically filled if \code{slopes_df} was produced using
\link[fluxible:flux_fitting]{flux_fitting}}

\item{ambient_conc}{ambient gas concentration in ppm at the site of
measurement (used to detect measurement that started with a polluted setup)}

\item{error}{error of the setup, defines a window outside of which
the starting values indicate a polluted setup}

\item{pvalue_threshold}{threshold of p-value below which the change of
gas concentration over time is considered not significant
(linear and quadratic fits)}

\item{rsquared_threshold}{threshold of r squared value below which
the linear model is considered an unsatisfactory fit
(linear and quadratic fits)}

\item{rmse_threshold}{threshold for the RMSE of each flux above which
the fit is considered unsatisfactory (exponential fits)}

\item{cor_threshold}{threshold for the correlation coefficient of
gas concentration with time below which the correlation
is considered not significant (exponential fits)}

\item{b_threshold}{threshold for the b parameter.
Defines a window with its opposite inside which the fit is
considered good enough (exponential fits)}

\item{cut_arg}{argument defining that the data point should be cut out}

\item{instr_error}{error of the instrument, in the same unit as the
gas concentration}

\item{kappamax}{logical. If \code{TRUE} the kappamax method will be applied.}
}
\value{
a dataframe with added columns of quality flags (\code{f_quality_flag}),
the slope corrected according to the quality flags (\code{f_slope_corr}),
and any columns present in the input.
It will also print a summary of the quality flags. This summary can also
be exported as a dataframe using
\link[fluxible:flux_flag_count]{flux_flag_count}
}
\description{
Indicates if the slopes provided by
\link[fluxible:flux_fitting]{flux_fitting} should be discarded or replaced
by 0 according to quality thresholds set by user
}
\details{
the kappamax method (Hüppi et al., 2018) selects the linear slope if
\ifelse{html}{\out{|b| > kappamax}}{\eqn{|b| > kappamax}{ASCII}}, with
\ifelse{html}{\out{kappamax = |f_slope_lm / instr_error|}}{\eqn{kappamax = |f_slope_lm / instr_error|}{ASCII}}.
The original kappamax method was applied to the HMR model
(Pedersen et al., 2010; Hutchinson and Mosier, 1981), but here it can be
applied to any exponential fit.
}
\examples{
data(co2_conc)
slopes <- flux_fitting(co2_conc, conc, datetime, fit_type = "exp_zhao18")
flux_quality(slopes, conc)
}
\references{
Pedersen, A.R., Petersen, S.O., Schelde, K., 2010.
A comprehensive approach to soil-atmosphere trace-gas flux estimation with
static chambers. European Journal of Soil Science 61, 888–902.
https://doi.org/10.1111/j.1365-2389.2010.01291.x

Hüppi, R., Felber, R., Krauss, M., Six, J., Leifeld, J., Fuß,
R., 2018. Restricting the nonlinearity parameter in soil greenhouse gas
flux calculation for more reliable flux estimates.
PLOS ONE 13, e0200876. https://doi.org/10.1371/journal.pone.0200876

Hutchinson, G.L., Mosier, A.R., 1981. Improved Soil Cover Method
for Field Measurement of Nitrous Oxide Fluxes.
Soil Science Society of America Journal 45, 311–316.
}
