% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_file.R
\name{import_file}
\alias{import_file}
\title{Download file from cloud to local system}
\usage{
import_file(bucketpath, localfile, data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), overwrite = TRUE,
  show_progress = FALSE, ...)
}
\arguments{
\item{bucketpath}{path of file in the bucket}

\item{localfile}{path where the file needs to be downloaded. The file name and extension also need to be present; if not, the current file name will be considered}

\item{data_source}{the name of the data source, if not set globally, gcs or s3}

\item{bucket}{the name of the bucket, if not set globally}

\item{overwrite}{logical. If the files should be overwritten if already present}

\item{show_progress}{logical. Shows progress of the download operation}

\item{...}{other parameters for gcs_get_object or save_object}
}
\value{
the filename and path of the object saved to local
}
\description{
Save a single file from the cloud to your local drive
}
\examples{
\dontrun{
# import data from GCS to Local
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
import_file("mtcars.csv", paste0(tempdir(), "/mtcars.csv"), overwrite = T)
}
}
