# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Construct new FM Index
#'
#' FM indices are data structures for memory efficient storage of large
#' sets of strings (corpus). Searches for partial matches with the corpus are
#' extremely fast.
#'
#' @param strings Vector of strings (corpus) to construct FM index from
#' @param case_sensitive Build case-sensitive index if TRUE
#' @return A FM Index object that can be passed to [fm_index_locate()] for
#'  finding matches in the corpus.
#'
#' @examples
#' data("state")
#' index <- fm_index_create(state.name, case_sensitive = FALSE)
#'
#' @family FM Index functions
#' @export
#' @importFrom stringi stri_trans_tolower
fm_index_create <- function(strings, case_sensitive = FALSE) {
    .Call(`_fm_index_fm_index_create`, strings, case_sensitive)
}

#' Locate given patterns
#'
#' Finds all occurrences of all given patterns in the FM Index, analogous to
#' [stringi::stri_locate()] and `str_locate()` from `stringr`.
#'
#' @param patterns Vector of strings to look for in the index
#' @param index Index created with [fm_index_create()]
#' @return A data frame with three columns. `pattern_index` is the index
#'   of the query pattern, `corpus_index` is the index of the matching
#'   string in the corpus, and `position` is the starting position of the
#'   match within the corpus string. All indices are 1-based.
#'
#' @examples
#' data("state")
#' index <- fm_index_create(state.name, case_sensitive = FALSE)
#' # Find all states with "new" in their names
#' hits <- fm_index_locate("new", index)
#' hits
#' # Show matching strings in library
#' state.name[hits$library_index]
#'
#' hits <- fm_index_locate("ar", index)
#' hits
#' state.name[hits$library_index]
#'
#' @family FM Index functions
#' @export
fm_index_locate <- function(patterns, index) {
    .Call(`_fm_index_fm_index_locate`, patterns, index)
}

#' Save / load FM indices
#'
#' FM indices can be stored on disk and loaded into memory again in order
#' to avoid re-computing the index every time a new R session is opened.
#'
#' @param index FM Index to be saved to disk
#' @param path Path where to save index to or load index from
#'
#' @return
#' For `fm_index_load`, a FM Index object that can be passed to [fm_index_locate()] for
#' finding matches in the corpus.
#'
#' For `fm_index_save`, no return value. Called for side-effects.
#'
#' @examples
#' data("state")
#' index_1 <- fm_index_create(state.name, case_sensitive = FALSE)
#'
#' tmp_path <- tempfile()
#' fm_index_save(index_1, tmp_path)
#' index_2 <- fm_index_load(tmp_path)
#'
#' identical(
#'   fm_index_locate("new", index_1),
#'   fm_index_locate("new", index_2)
#' )
#'
#' @describeIn fm_index_save Save FM Index to disk
#' @family FM Index functions
#' @export
fm_index_save <- function(index, path) {
    invisible(.Call(`_fm_index_fm_index_save`, index, path))
}

#' @describeIn fm_index_save Load FM Index from disk
#' @export
fm_index_load <- function(path) {
    .Call(`_fm_index_fm_index_load`, path)
}

