% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-methods.R, R/zero-curve-class.R
\name{interpolate_zeros}
\alias{interpolate_zeros}
\alias{interpolate_zeros.ZeroCurve}
\title{Interpolate zeros}
\usage{
interpolate_zeros(x, at, compounding = NULL, day_basis = NULL, ...)

\method{interpolate_zeros}{ZeroCurve}(x, at, compounding = NULL,
  day_basis = NULL, ...)
}
\arguments{
\item{x}{the object to interpolate}

\item{at}{a \link{Date} vector representing the date at which to interpolate a
value}

\item{compounding}{a valid \link[=is_valid_compounding]{compounding} string.
Defaults to \code{NULL} which uses the curve's native compounding basis}

\item{day_basis}{a valid \link[fmdates:is_valid_day_basis]{day basis} string.
Defaults to \code{NULL} which uses the curve's native day basis.}

\item{...}{further arguments passed to specific methods}
}
\value{
an \link[=InterestRate]{InterestRate} object of interpolated zero rates
with the \code{compounnding} and \code{day_basis} requested.
}
\description{
This interpolates zero rates from either a \link[=ZeroCurve]{ZeroCurve} or some
other object that contains such an object.
}
\seealso{
Other interpolate functions: \code{\link{interpolate.ZeroCurve}},
  \code{\link{interpolate_dfs}}, \code{\link{interpolate}}
}
