% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice_Nd.R
\name{fm_lattice_Nd}
\alias{fm_lattice_Nd}
\alias{fm_lattice_Nd.matrix}
\alias{fm_lattice_Nd.data.frame}
\alias{fm_lattice_Nd.list}
\alias{fm_lattice_Nd.fm_bbox}
\alias{fm_lattice_Nd.NULL}
\title{Lattice grids for N dimensions}
\usage{
fm_lattice_Nd(x = NULL, ...)

\method{fm_lattice_Nd}{matrix}(x = NULL, dims = NULL, values = NULL, ...)

\method{fm_lattice_Nd}{data.frame}(x = NULL, ...)

\method{fm_lattice_Nd}{list}(x = NULL, dims = NULL, ...)

\method{fm_lattice_Nd}{fm_bbox}(x = NULL, dims = NULL, ...)

\method{fm_lattice_Nd}{`NULL`}(x = NULL, ..., dims = NULL)
}
\arguments{
\item{x}{\code{list}, \code{data.frame}, \code{matrix}, \code{fm_bbox} or \code{NULL}. If a list of
vectors, \code{as.matrix(expand.grid(x))} is used to create a full grid
coordinates. \code{data.frame} and \code{matrix} input is assumed to follow the same
ordering convention as the output of \code{expand.grid()}. of length N of
vectors or grid matrices of coordinate values. List vector values are
sorted before use.}

\item{...}{Passed on to submethods}

\item{dims}{numeric; the size of the grid of dimension \code{length(dims)}}

\item{values}{list of grid axis values}
}
\value{
An \code{fm_lattice_Nd} object with elements
\describe{
\item{dims}{integer vector}
\item{values}{the grid coordinate axis values}
\item{loc}{matrix of constructed grid coordinates}
}
}
\description{
Construct an N-dimensional lattice grid
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_lattice_Nd(`NULL`)}: Ignores the \code{NULL} \code{x} and creates a lattice
based on \code{values} (if non-NULL) and \code{dims} unit hypercube
lattice grid with \code{dims} dimensions.

}}
\examples{
(lattice <- fm_lattice_Nd(
  list(
    seq(0, 1, length.out = 3),
    seq(0, 1, length.out = 4),
    seq(0, 1, length.out = 2)
  )
))

if (requireNamespace("geometry", quietly = TRUE)) {
  (mesh <- fm_delaunay_3d(lattice$loc))
}
}
\seealso{
\code{\link[=fm_mesh_3d]{fm_mesh_3d()}}

Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\concept{object creation and conversion}
