% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_testthat}
\alias{local_testthat}
\alias{local_fm_testthat_assign}
\alias{local_fm_testthat_tolerances}
\alias{local_fm_testthat_setup}
\title{Unit test helpers}
\usage{
local_fm_testthat_assign(x, values, envir = parent.frame())

local_fm_testthat_tolerances(
  tolerances = c(1e-04, 0.01, 0.1),
  envir = parent.frame()
)

local_fm_testthat_setup(envir = parent.frame())
}
\arguments{
\item{x}{character; Name of variable to assign to}

\item{values}{the object to assign to \code{x}}

\item{envir}{environment for exit handlers}

\item{tolerances}{numeric vector of length 3; \verb{[lowtol, midtol, hitol]}}
}
\value{
None
}
\description{
Local helper functions for package unit tests
}
\section{Functions}{
\itemize{
\item \code{local_fm_testthat_assign()}: Assign local variable. Useful for easy cleanup
of global workspace with \code{withr::deferred_run()} when running tests
interactively.

\item \code{local_fm_testthat_tolerances()}: Assign test tolerances
Assign local tolerance variables. Useful for easy cleanup
of global workspace with \code{withr::deferred_run()} when running tests
interactively.

\item \code{local_fm_testthat_setup()}: Initialise environment for tests.
To be called either at the top of a testfile, or inside tests.

}}
\examples{
outer_fun <- function() {
  fun <- function(envir = parent.frame()) {
    local_fm_testthat_assign("local_var_name", 1:4, envir = envir)
  }
  fun()
  local_var_name
}
exists("local_var_name")
outer_fun()
exists("local_var_name")

}
\keyword{internal}
