% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{tuning}
\alias{tuning}
\alias{tuning.formula}
\alias{tuning.default}
\title{Tuning For Fast Class Noise Detector with Multi-Factor-Based Learning}
\usage{
tuning(x, ...)

\method{tuning}{formula}(formula, data, ...)

\method{tuning}{default}(
  x,
  knn_k = seq(3, 7, 2),
  classColumn = 1,
  boxplot_range = seq(0.1, 1.1, 0.2),
  repeats = 10,
  method = "svm",
  iForest = TRUE,
  threads = 1,
  ...
)
}
\arguments{
\item{...}{Optional parameters to be passed to other methods.}

\item{formula}{a formula describing the classification variable and the attributes to be used.}

\item{data, x}{data frame containing the tranining dataset to be filtered.}

\item{knn_k}{range of the total number of nearest neighbors to be used.The default is 3:5.}

\item{classColumn}{positive integer indicating the column which contains the
(factor of) classes. By default, a dataframe built from 'data' using the variables indicated in 'formula' and The first column is the response variable, thus no need to define the classColumn.}

\item{boxplot_range}{range of box and whisker diagram. The default is seq(0.8,1.2,0.1).}

\item{repeats}{the number of cross-validation. The default is 10.}

\item{method}{the classifier to be used to compute the accuracy. The valid methods are svm (default) and c50.}

\item{iForest}{compute iForest score or not. The dafault is TRUE.}

\item{threads}{the number of cores to be used in parallel}
}
\value{
An object of class \code{filter}, which is a list with two components:
\itemize{
   \item \code{summary} is the a vector of values when different hyper-parameter is set.
   \item \code{call} contains the original call to the filter.
}
}
\description{
This function tunes the hyper-parameters the threshold and the k of k-NN
}
\examples{
\donttest{
data(iris)
out = tuning(Species~.,iris)
}
}
\author{
Wanwan Zheng
}
