% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secDetails.R
\name{fmpc_earning_call_transcript}
\alias{fmpc_earning_call_transcript}
\title{Full transcript of earnings call}
\usage{
fmpc_earning_call_transcript(symbols = c("AAPL"), quarter = 2, year = 2020)
}
\arguments{
\item{symbols}{one or more symbols from the FMP available list that can be
found using \code{\link{fmpc_symbols_available}}. A valid API token must be
set in order to enable functionality. See documentation for setting a token
under \code{\link{fmpc_set_token}}.}

\item{quarter}{earnings year quarter}

\item{year}{earnings call year}
}
\value{
earnings call transcript in data frame
}
\description{
Full transcript of earnings call
}
\examples{

\dontrun{

# Demo can pull AAPL
fmpc_set_token()
fmpc_earning_call_transcript('AAPL',quarter = 1, year = 2019)

# For multiple symbols, set a valid API Token
fmpc_set_token('FMPAPIKEY')
fmpc_earning_call_transcript(c('AAPL','MSFT','SPY'))

}

}
