% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_number.R
\name{abc.factor.number}
\alias{abc.factor.number}
\title{Factor number estimator of Alessi, Barigozzi and Capasso (2010)}
\usage{
abc.factor.number(x, covx = NULL, q.max = NULL, do.plot = FALSE, center = TRUE)
}
\arguments{
\item{x}{input time series matrix, with each row representing a variable}

\item{covx}{covariance of \code{x}}

\item{q.max}{maximum number of factors; if \code{q.max = NULL}, a default value is selected as \code{min(50, floor(sqrt(min(dim(x)[2] - 1, dim(x)[1]))))}}

\item{do.plot}{whether to plot the value of the information criterion}

\item{center}{whether to de-mean the input \code{x} row-wise}
}
\value{
a list containing
\item{q.hat}{ the mimimiser of the chosen information criteria}
}
\description{
Estimates the number of factors by minimising an information criterion over sub-samples of the data.
Currently the three information criteria proposed in Alessi, Barigozzi and Capasso (2010) (\code{ic.op = 1, 2, 3})
and their variations with logarithm taken on the cost (\code{ic.op = 4, 5, 6}) are implemented,
with \code{ic.op = 5} recommended as a default choice based on numerical experiments.
}
\details{
See Bai and Ng (2002) for further details.
}
\examples{
library(fnets)

set.seed(123)
n <- 500
p <- 50
common <- sim.restricted(n, p)
idio <- sim.var(n, p)
x <- common$data * apply(idio$data, 1, sd) / apply(common$data, 1, sd) + idio$data

abc <- factor.number(x, fm.restricted = TRUE, do.plot = TRUE)
abc

er <- factor.number(x, method = "er", fm.restricted = TRUE, do.plot = TRUE)
er
}
\references{
preprint

Alessi, L., Barigozzi, M.,  & Capasso, M. (2010) Improved penalization for determining the number of factors in approximate factor models. Statistics & Probability Letters, 80(23-24):1806–1813.

Bai, J. & Ng, S. (2002) Determining the number of factors in approximate factor models. Econometrica. 70: 191-221.

Owens, D., Cho, H. & Barigozzi, M. (2022) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling
}
\keyword{internal}
