#' Harvard Foood Frequency Questionnaire Nutrition Information
#'
#' This dataframe is used internally by the functions of foodquotient and
#' includes portion size information by age for each of the 85 foods included in
#' the HSFFQ from the HSFFQ user's manual. Additionally, nutrient information
#' is included for each of the 85 foods, pulled from the USDA's public search
#' tool.
#'
#'
#' @return A portion size and nutrient information reference data frame.
#' @export
#'
#'
#'
hsffq <- function() {
  structure(
    list(
      "food" = c("milk", "hot_choc", "cheese", "yogurt",
                 "ice_cream", "pudding", "orange_juice", "juice_other", "fruit_drink",
                 "banana", "peaches", "mixed_fruit", "orange", "apple_pear", "applesauce",
                 "grapes", "strawberries", "melon", "pineapple", "raisins", "corn",
                 "peas", "tomato", "peppers", "carrots", "broccoli", "green_beans",
                 "spinach", "greens", "mixed_veg", "squash", "zucchini", "potatoes_fried",
                 "potatoes", "sweet_potatoes", "cabbage", "lettuce", "mayo", "chips",
                 "popcorn", "crackers", "nuts", "cookies", "cake", "pie", "jello",
                 "choc", "candy", "coffee", "soda", "soda_sf", "beans", "rice",
                 "pasta", "pizza", "tacos", "mac_cheese", "hot_dogs", "sausage",
                 "hamburger", "tuna", "fish_fried", "fish", "cold_cuts", "nuggets",
                 "chicken", "pork", "beef", "organ_meats", "peanut_but", "bread",
                 "butter", "margarine", "veg_soup", "soup", "tortilla", "eggs",
                 "bacon", "hot_cereal", "cold_cereal", "donuts", "muffins", "pancake",
                 "bagels", "biscuits"),
      "gm_per_serv_avg" = c(226, 222, 32, 151,
                            151, 151, 268, 271, 373, 111, 79, 132, 132, 135, 134, 42, 44,
                            132, 132, 42, 101, 86, 53, 16, 72, 119, 90, 97, 97, 119, 72,
                            72, 83, 157, 120, 62, 41, 12, 39, 41, 26, 27, 8, 92, 150, 20,
                            44, 33, 463, 423, 420, 133, 150, 162, 169, 169, 244, 67, 43,
                            139, 65, 110, 110, 67, 95, 95, 83, 61, 20, 27, 50, 11, 10, 369,
                            369, 60, 68, 20, 248, 54, 77, 82, 85, 79, 61),
      "gm_per_serv_2.5" = c(196,
                            202, 24, 92, 92, 92, 190, 207, 235, 95, 52, 103, 103, 106, 118,
                            60, 26, 103, 103, 60, 68, 48, 31, 5, 48, 61, 50, 31, 31, 61,
                            48, 48, 52, 81, 70, 33, 17, 8, 24, 20, 17, 19, 11, 70, 76, 16,
                            28, 24, 79, 224, 217, 71, 84, 90, 86, 86, 159, 49, 33, 58, 38,
                            64, 64, 49, 52, 52, 48, 31, 15, 19, 37, 6, 6, 238, 238, 32, 48,
                            15, 211, 33, 59, 55, 49, 51, 38),
      "gm_per_serv_6.11" = c(241, 244,
                             29, 135, 135, 135, 224, 223, 290, 105, 49, 114, 114, 123, 130,
                             45, 34, 114, 114, 45, 79, 72, 42, 8, 46, 102, 71, 71, 71, 102,
                             46, 46, 67, 103, 95, 41, 26, 9, 29, 31, 26, 24, 12, 79, 116,
                             19, 36, 27, 198, 329, 297, 95, 124, 130, 108, 108, 217, 57, 32,
                             87, 57, 93, 93, 57, 70, 70, 62, 41, 19, 24, 44, 9, 8, 314, 314,
                             47, 58, 19, 245, 47, 69, 67, 77, 65, 48),
      "calories" = c(0.61,
                     3.98, 3.685, 1.02, 2.07, 1.224, 0.45, 0.46, 0.35, 0.89, 0.74,
                     0.73, 0.47, 0.52, 0.68, 0.69, 0.32, 0.34, 0.78, 2.99, 0.81, 0.78,
                     0.18, 0.2, 0.35, 0.35, 0.28, 0.23, 0.28, 0.65, 0.37, 0.15, 3.146,
                     1, 1.08, 0.25, 0.14, 6.8, 5.475, 5.508, 4.21, 6.07, 4.74, 3.79,
                     2.581, 0.62, 5.35, 3.94, 0.01, 0.37, 0.001, 1.06, 1.3, 1.58,
                     2.666, 2.16, 1.923, 3.13, 3.39, 2.71, 1.87, 2.49, 1.05, 3.08,
                     2.69, 1.9, 2.22, 2.64, 1.75, 5.88, 2.65, 7.17, 0, 0.31, 0.25,
                     2.903, 1.43, 4.84, 0.71, 3.79, 4.415, 3.711, 2.27, 2.27, 3.162
      ),
      "protein" = c(0.032, 0.067, 0.181, 0.044, 0.035, 0.02, 0.007,
                    0.001, 0, 0.011, 0.004, 4e-04, 0.009, 0.003, 0.002, 7e-04, 0.007,
                    0.008, 0.003, 0.031, 0.025, 0.052, 0.009, 0.009, 0.008, 0.024,
                    0.015, 0.03, 0.019, 0.029, 0.009, 0.011, 0.039, 0.021, 0.013,
                    0.0128, 0.009, 0.01, 0.072, 0.077, 0.095, 0.2, 0.051, 0.032,
                    0.024, 0.012, 0.077, 0, 0.001, 0.001, 0, 0.052, 0.027, 0.058,
                    0.125, 0.091, 0.058, 0.112, 0.194, 0.258, 0.16, 0.11, 0.228,
                    0.152, 0.286, 0.289, 0.244, 0.264, 0.265, 0.251, 0.091, 0.009,
                    0, 0.022, 0.013, 0.06, 0.126, 0.3741, 0.025, 0.131, 0.042, 0.049,
                    0.064, 0.089, 0.057),
      "fat" = c(0.032, 0.097, 0.312, 0.011, 0.11,
                0.036, 0.001, 0.001, 0, 0.003, 0.001, 0.001, 0.001, 0.002, 0.175,
                0.002, 0.003, 0.002, 0.001, 0.005, 0.007, 0.003, 0.002, 0.002,
                0.002, 0.004, 0.002, 0.003, 0.004, 0.002, 0.003, 0.004, 0.151,
                0.001, 0.003, 0.001, 0.001, 0.748, 0.364, 0.33, 0.089, 0.54,
                0.233, 0.178, 0.125, 0, 0.297, 0.002, 0, 0, 0, 0.015, 0.003,
                0.009, 0.113, 0.112, 0.09, 0.278, 0.284, 0.178, 0.093, 0.132,
                0.009, 0.246, 0.149, 0.074, 0.13, 0.168, 0.047, 0.504, 0.032,
                0.811, 0, 0.008, 0.009, 0.102, 0.095, 0.358, 0.015, 0.065, 0.27,
                0.16, 0.097, 0.017, 0.136),
      "carb" = c(0.048, 0.837, 0.042, 0.19,
                 0.236, 0.214, 0.108, 0.113, 0.09, 0.228, 0.199, 0.189, 0.118,
                 0.138, 0.03, 0.181, 0.077, 0.082, 0.202, 0.792, 0.193, 0.143,
                 0.039, 0.046, 0.082, 0.072, 0.064, 0.038, 0.056, 0.131, 0.089,
                 0.027, 0.401, 0.233, 0.254, 0.058, 0.03, 0.006, 0.535, 0.557,
                 0.743, 0.21, 0.639, 0.554, 0.345, 0.142, 0.594, 0.629, 0, 0.096,
                 0, 0.2, 0.282, 0.309, 0.29, 0.2, 0.224, 0.037, 0, 0, 0.094, 0.212,
                 0, 0.055, 0.032, 0, 0, 0, 0.052, 0.196, 0.491, 0.001, 0, 0.041,
                 0.03, 0.456, 0.007, 0.019, 0.12, 0.677, 0.48, 0.528, 0.283, 0.442,
                 0.433),
      "calcium" = c(1.13, 0.665, 10.45, 2.1, 1.28, 1.02, 0.09,
                    0.08, 0.16, 0.05, 0.03, 0.06, 0.4, 0.06, 0.0012, 0.1, 0.16, 0.09,
                    0.14, 0.5, 0.03, 0.24, 0.1, 0.1, 0.3, 0.4, 0.42, 1.36, 0.72,
                    0.25, 0.22, 0.18, 0.13, 0.05, 0.17, 0.4, 0.18, 0.08, 0, 0.208,
                    0.21, 1.17, 0.26, 0.32, 0.329, 0.03, 1.89, 0.03, 0.02, 0.03,
                    0.04, 0.53, 0.1, 0.07, 2.625, 1.06, 0.967, 0.13, 0.13, 0.24,
                    0.17, 0.26, 0.14, 0.85, 0.17, 0.15, 0.28, 0.19, 0.06, 0.43, 2.6,
                    0.24, 0, 0.08, 0.06, 1.148, 0.56, 0.12, 0.09, 0.52, 0.784, 0.46,
                    2.19, 1.63, 0.254),
      "iron" = c(3e-04, 0.0119, 0.0063, 7e-04, 9e-04,
                 0.0037, 0.001, 0.0012, 5e-04, 0.0026, 0.0027, 0.0029, 0.001,
                 0.0012, 0.0012, 0.0036, 0.0041, 0.0021, 0.0038, 0.0188, 0.047,
                 0.0152, 0.0027, 0.0034, 0.0034, 0.0067, 0.0066, 0.0357, 0.009,
                 0.0082, 0.0044, 0.0037, 0.0107, 0.0041, 0.0095, 0.0047, 0.0041,
                 0.0021, 0.0128, 0.0191, 0.0513, 0.0261, 0.032, 0.0203, 0.0098,
                 2e-04, 0.0235, 0.003, 1e-04, 0.0011, 4e-04, 0.017, 0.012, 0.0128,
                 0.0165, 0.0143, 0.007, 0.0125, 0.0136, 0.0248, 0.01, 0.0101,
                 0.0049, 0.0121, 0.0138, 0.0121, 0.0068, 0.0169, 0.0617, 0.0187,
                 0.0359, 2e-04, 0, 0.0045, 0.0066, 0.0171, 0.0175, 0.0112, 0.009,
                 0.0425, 0.0155, 0.0136, 0.018, 0.04, 0.0236),
      "zinc" = c(0.0037,
                 0.0146, 0.0249, 0.0074, 0.0069, 0.0031, 5e-04, 2e-04, 2e-04,
                 0.0015, 9e-04, 8e-04, 7e-04, 4e-04, 3e-04, 7e-04, 0.0014, 0.0018,
                 0.0012, 0.0022, 0.0063, 0.0067, 0.0017, 0.0013, 0.002, 0.0045,
                 0.0024, 0.0076, 0.0024, 0.0049, 0.0022, 0.0033, 0.0077, 0.0033,
                 0.0016, 0.0018, 0.0015, 0.0015, 0.0095, 0.022, 0.0082, 0.0336,
                 0.0065, 0.0042, 0.0024, 1e-04, 0.023, 1e-04, 2e-04, 2e-04, 0,
                 0.0146, 0.0049, 0.0051, 0.0135, 0.0156, 0.0067, 0.0206, 0.0208,
                 0.0625, 0.0056, 0.0048, 0.0058, 0.023, 0.0204, 0.021, 0.0215,
                 0.0475, 0.0523, 0.0291, 0.0084, 9e-04, 0, 0.0062, 0.0016, 0.0056,
                 0.0129, 0.0331, 0.01, 0.0364, 0.0035, 0.0052, 0.0056, 0.0105,
                 0.004),
      "vitamin.c" = c(0, 0.002, 0, 0.007, 0.006, 0, 0.389, 0.009,
                      0.112, 0.087, 0.028, 0.019, 0.532, 0.046, 0.017, 0.032, 0.588,
                      0.367, 0.074, 0.023, 0.035, 0.099, 0.137, 0.804, 0.036, 0.649,
                      0.041, 0.098, 0.41, 0.032, 0.096, 0.129, 0.04, 0.151, 0.108,
                      0.366, 0.028, 0, 0.215, 0.001, 0, 0.005, 0, 0, 0.018, 0, 0, 0,
                      0, 0, 0, 0.02, 0, 0, 0.024, 0.002, 0, 0, 0.007, 0, 0.022, 0,
                      0.01, 0.008, 0, 0, 0, 0, 0.007, 0, 0, 0, 0, 0.01, 0, 0.001, 0,
                      0, 0, 0, 0, 0, 0.003, 0.018, 0.001),
      "vitamin.b6" = c(4e-04, 0.0011,
                       5e-04, 4e-04, 5e-04, 2e-04, 4e-04, 2e-04, 0, 0.0037, 2e-04, 5e-04,
                       6e-04, 4e-04, 3e-04, 9e-04, 5e-04, 7e-04, 7e-04, 0.0017, 0.001,
                       0.0011, 8e-04, 0.0022, 0.0015, 0.002, 6e-04, 0.0024, 0.0014,
                       7e-04, 0.0016, 8e-04, 0.0035, 0.0032, 6e-04, 0.00124, 4e-04,
                       1e-04, 0.002, 0.0029, 6e-04, 0.0035, 3e-04, 0, 4e-04, 0, 0.004,
                       0, 0, 0, 0, 6e-04, 9e-04, 5e-04, 0.0012, 7e-04, 5e-04, 0.0019,
                       0.0033, 0.0037, 8e-04, 5e-04, 0.0028, 0.003, 0.0041, 0.0047,
                       0.0064, 0.0055, 0.0103, 0.0054, 9e-04, 0, 0, 3e-04, 2e-04, 7e-04,
                       0.0017, 0.00535, 0, 0.001, 3e-04, 7e-04, 0.0018, 5e-04, 3e-04
      ),
      "vitamin.a" = c(0.46, 0.01, 2.836, 0.618, 1.176, 0, 0.05, 0,
                      0, 0.03, 0.17, 0.1, 0.11, 0.03, 0.003, 0.03, 0.01, 1.69, 0.01,
                      0, 0.1, 1.05, 0.42, 0.18, 8.52, 0.77, 0.28, 5.24, 6.81, 2.14,
                      3.494, 0.56, 0, 0, 4.58, 0.05, 0.25, 0.157, 0.017, 0.183, 0,
                      0.002, 0, 0.343, 0.014, 0, 0.59, 0, 0, 0, 0, 0.001, 0, 0, 0.655,
                      0.188, 0.695, 0, 0.12, 0, 0.244, 0.25, 0.14, 0.25, 0.27, 0.16,
                      0.02, 0, 77.44, 0, 0, 6.84, 0, 0.388, 0.152, 0.411, 1.6, 0.11,
                      0, 0, 0.078, 0.055, 0.532, 0, 0.008),
      "folate" = c(0.05, 0.06,
                   0.08, 0.09, 0.05, 0.03, 0.44, 0, 0, 0.2, 0.03, 0.03, 0.3, 0.03,
                   0.01, 0.02, 0.24, 0.21, 0.05, 0.05, 0.35, 0.59, 0.15, 0.1, 0.14,
                   1.08, 0.23, 1.46, 0.13, 0.19, 0.2, 0.28, 0.3, 0.12, 0.08, 0.43,
                   0.29, 0.05, 0.84, 0.15, 2.219, 0.83, 0.693, 0.318, 0.657, 0.01,
                   0.11, 0, 0.02, 0, 0, 0.36, 0.965, 1.192, 0.969, 0.568, 0.818,
                   0.1, 0.03, 0.1, 0.08, 0.498, 0.08, 0.06, 0.111, 0.06, 0, 0.08,
                   2.6, 0.74, 1.712, 0.03, 0, 0.04, 0.122, 1.142, 0.47, 0, 0.06,
                   0.32, 0.809, 1.304, 0.562, 1.335, 1.425)
    ),
    row.names = c(NA, -85L),
    spec = structure(
      list(
        cols = list(
          "food" = structure(
            list(),
            class = c("collector_character", "collector")
          ),
          "gm_per_serv_avg" = structure(list(), class = c("collector_double", "collector")),
          "gm_per_serv_2.5" = structure(list(), class = c("collector_double", "collector")),
          "gm_per_serv_6.11" = structure(list(), class = c("collector_double", "collector")),
          "calories" = structure(list(), class = c("collector_double", "collector")),
          "protein" = structure(list(), class = c("collector_double", "collector")),
          "fat" = structure(list(), class = c("collector_double", "collector")),
          "carb" = structure(list(), class = c("collector_double", "collector")),
          "calcium" = structure(list(), class = c("collector_double", "collector")),
          "iron" = structure(list(), class = c("collector_double", "collector")),
          "zinc" = structure(list(), class = c("collector_double", "collector")),
          "vitamin.c" = structure(list(), class = c("collector_double", "collector")),
          "vitamin.b6" = structure(list(), class = c("collector_double", "collector")),
          "vitamin.a" = structure(list(), class = c("collector_double", "collector")),
          "folate" = structure(list(), class = c("collector_double", "collector"))
        ),
        default = structure(
          list(),
          class = c("collector_guess", "collector")
        ),
        delim = ","
      ),
      class = "col_spec"),
    class = c("data.frame")
  )
}
