% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_avri.r
\name{geom_avri}
\alias{geom_avri}
\title{Plot the average variation}
\usage{
geom_avri(
  df,
  cave = 2,
  csd = 3,
  ssd = 1,
  alpha = 0.5,
  xlab = NULL,
  ylab = NULL,
  lcc = NULL,
  lsize = 1,
  rff = NULL
)
}
\arguments{
\item{df}{dataframe contains average variation value and their standard deviation.}

\item{cave}{column index of average variation. The default vaule is 2.}

\item{csd}{column index of standard deviation. The default vaule is 3.}

\item{ssd}{scale value for standard deviation. The default vaule is 1.}

\item{alpha}{the alpha value of ribbon. The default vaule is 0.5.}

\item{xlab}{text expression of x axis label. The default vaule is NULL.}

\item{ylab}{text expression of y axis label. The default vaule is NULL.}

\item{lcc}{color of line. The default vaule is NULL.}

\item{lsize}{size of line. The default vaule is NULL.The default vaule is 1.}

\item{rff}{fill color of ribbon. The default vaule is NULL.}
}
\description{
Easy way to plot the average variation.
}
\examples{
\dontrun{ 
x=avri(aqi, bkip = "1 hour", mode = "recipes", value
 = "day", st = "2017-05-01 00:00:00")
geom_avri(x,cave=6, csd=11, alpha=0.5, lcc="#0050b3",
 rff="#40a9ff", xlab="Time",ylab=bquote(O[3]~" "~(ppbv)))
}
}
