% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.xml.R
\name{depth.xml}
\alias{depth.xml}
\title{Import image object depth (Z)}
\usage{
\method{depth}{xml}(x, ...)
}
\arguments{
\item{x}{file containing metadata, if xml type: \code{'.xml', '.tif_meta.xml'}}

\item{...}{other arguments.}
}
\value{
A `data.frame` with the following information:
\itemize{
  \item {file} : {filename}
  \item {z_depth} : {measured focus range depth (z)}}
}
\description{
The function retrieves the object depth information from image metadata as source.
}
\examples{
\dontrun{
#Path to example file from package
meta <- system.file("extdata", "foram.tif_meta.xml", package="forImage")

#retrieve z-depth data
depth.xml(meta)}

}
