% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributeCalculator.R
\name{calculateAttributes}
\alias{calculateAttributes}
\title{Calculates the attributes of the hydroclimate time series}
\usage{
calculateAttributes(climateData, attSel, startYr = NULL, endYr = NULL)
}
\arguments{
\item{climateData}{data.frame or list; daily climate data, the attributes of which are to be calculated. \cr 
If \code{climateData} is a data.frame, it must have columns named \emph{year}, \emph{month}, \emph{day}, \emph{*variable_name1*}, \emph{*variable_name2*}. 
Note that the first three columns of the data.frame contain the year, month, and day of the data. 
The columns have to be named as specified. 
Data.frame format is applicable for single site data only. \cr
If \code{climateData} is a list, it must have elements named \emph{year}, \emph{month}, \emph{day}, \emph{*variable_name1*}, \emph{*variable_name2*}. List format is suitable for both single and multi-site data. 
For multi-site data, climate variables are specified as matrices, with columns for each site. \cr   
Use \code{viewModels()} to view the valid variable names. 
Please refer to data provided with the package that may be loaded using \code{data(tankDat)} and \code{data(barossaDat)} for examples of the expected format of single site and multi-site \code{climateData}.}

\item{attSel}{a vector; specifying the names of the attributes to be calculated.}

\item{startYr}{a number (default \code{NULL}); to specify the starting year to subset \code{climateData} if required. 
If \code{NULL}, \code{startYr} is starting year in the input \code{climateData}.}

\item{endYr}{a number (default \code{NULL}); to specify the ending year to subset \code{climateData} if required. 
If \code{NULL}, \code{endYr} is last year in the input \code{climateData}.}
}
\value{
The function returns a vector of attributes with names of the attributes (\code{attSel}). 
For multi-site data, names are combinations of attribute and site names.
}
\description{
\code{calculateAttributes} calculates the specified attributes of the input daily hydroclimate time series.
}
\examples{
#----------------------------------------------------------------------
# Example 1: Single-site data.frame input
# load 'tank' example climate data available in the package
data("tankDat")
# specify rainfall and temperature attributes to calculate
attSel <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_R10_m", "Temp_ann_rng_m", "Temp_ann_avg_m")
tank_obs_atts <- calculateAttributes(tank_obs, attSel = attSel)
#----------------------------------------------------------------------
# Example 2: Multi-site list input
# load 'Barossa' example climate data available in the package
data("barossaDat")
# specify rainfall attributes to calculate
attSel <- c("P_ann_tot_m", "P_ann_nWet_m", "P_ann_P99")
barossa_obs_atts <- calculateAttributes(tank_obs, attSel = attSel)
}
