% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_params.R
\name{extract_params}
\alias{extract_params}
\title{Extract forest parameters}
\usage{
extract_params(x)
}
\arguments{
\item{x}{a \code{randomForest} or \code{ranger} object}
}
\value{
a list of four elements
\itemize{
\item \strong{Fn} The number of features considered at each internal node (mtry)
\item \strong{Ft} The total number of features in the data set
\item \strong{K} The average number of binary tests/internal nodes across the enitre forest
\item \strong{Tr} The total number of trees in the forest
}
}
\description{
For a \code{randomForest} or \code{ranger} classification object, extract the parameters needed to calculate an approximate selection frequency threshold
}
\examples{
library(randomForest)
data(iris)
iris.rf <- randomForest(iris[,-5], iris[,5], forest = TRUE)

iris.params <- extract_params(iris.rf)
print(iris.params)
}
\author{
Tom Wilson \email{tpw2@aber.ac.uk}
}
