% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_functions.R
\name{focal_vs_comp_distance}
\alias{focal_vs_comp_distance}
\title{Return all pairwise distances between two data frames of trees}
\usage{
focal_vs_comp_distance(focal_trees, comp_trees)
}
\arguments{
\item{focal_trees}{An \code{sf} polygon object of the focal trees of interest}

\item{comp_trees}{An \code{sf} polygon object of the competitor trees}
}
\value{
A data frame with three columns: \code{focal_ID} of focal tree,
\code{comp_dist} of competitor tree, and \code{dist} of distance between
them.
}
\description{
Return all pairwise distances between two data frames of trees
}
\examples{
library(tibble)
library(ggplot2)
library(sf)

# Create toy example focal and competitor trees
focal_trees <- tibble(
  focal_ID = c(1, 2, 3),
  x = c(0.3, 0.6, 0.7),
  y = c(0.1, 0.5, 0.7)
) \%>\%
  st_as_sf(coords = c("x", "y"))

comp_trees <- tibble(
  comp_ID = c(4, 5, 6, 7),
  x = c(0, 0.2, 0.4, 0.6),
  y = c(0.6, 0.7, 1, 0.2)
) \%>\%
  st_as_sf(coords = c("x", "y"))

# Plot both sets of trees
ggplot() +
  geom_sf_label(data = focal_trees, aes(label = focal_ID), col = "black") +
  geom_sf_label(data = comp_trees, aes(label = comp_ID), col = "orange") +
  labs(title = "Focal trees in black, competitor trees in orange")

# Compute corresponding distances between the 3 focal trees and 4 competitor trees
focal_vs_comp_distance(focal_trees, comp_trees)
}
\seealso{
Other spatial functions: 
\code{\link{add_buffer_variable}()},
\code{\link{compute_buffer_region}()}
}
\concept{spatial functions}
