% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BG.R
\name{BG}
\alias{BG}
\title{Beta Geometric (BG) Model for Projecting Customer Retention.}
\usage{
BG(surv_value, h, lower = c(0.001, 0.001))
}
\arguments{
\item{surv_value}{a numeric vector of historical customer retention percentage should start at 100 and non-starting values should be between 0 and less than 100}

\item{h}{forecasting horizon}

\item{lower}{lower limit used in \code{R} \code{optim} rotuine. Default is \code{c(1e-3,1e-3)}.}
}
\value{
\item{fitted:}{Fitted Values based on historical data} \item{max.likelihood:}{Maximum Likelihood of Beta Geometric}
\item{params - a, b:}{Returns a and b paramters from maximum likelihood estimation for beta distribution}
}
\description{
\code{BG} is a beta geometric model implemented based on \code{Fader and Hardie} probability based projection methedology. The survivor function for \code{BG} is \deqn{Beta(a,b+t)/Beta(a,b)}
}
\examples{
surv_value <- c(100,86.9,74.3,65.3,59.3)
h <- 6
BG(surv_value,h)

}
\references{
{Fader  PS and Hardie BGS (2007), How to project customer retention. Volume 21, Issue 1. Journal of Interactive Marketing}
}
