% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/tostring.R
\name{toString}
\alias{toString}
\alias{toString,MatrixPrintForm-method}
\title{toString

Transform a complex object into a string representation ready
to be printed or written to a plain-text file}
\usage{
toString(x, ...)

\S4method{toString}{MatrixPrintForm}(x, widths = NULL, col_gap = 3, linesep = "—")
}
\arguments{
\item{x}{ANY. Object to be prepared for rendering.}

\item{...}{Passed to individual methods.}

\item{widths}{(proposed) widths for the columns of \code{x}}

\item{col_gap}{numeric(1). Space between columns}

\item{linesep}{character(1). Characters to repeat to create header/body
separator line.}
}
\value{
A character string containing the ASCII rendering
of the table-like object reprseented by `x`
}
\description{
toString

Transform a complex object into a string representation ready
to be printed or written to a plain-text file
}
\examples{
mform <- basic_matrix_form(mtcars)
cat(toString(mform))
}
