% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{round_fmt}
\alias{round_fmt}
\alias{rounding}
\title{Round and prepare a value for display}
\usage{
round_fmt(x, digits, na_str = "NA")
}
\arguments{
\item{x}{(\code{numeric(1)})\cr value to format.}

\item{digits}{(\code{numeric(1)})\cr number of digits to round to, or \code{NA} to convert to a
character value with no rounding.}

\item{na_str}{(\code{string})\cr the value to return if \code{x} is \code{NA}.}
}
\value{
A character value representing the value after rounding, containing any trailing zeros
required to display \emph{exactly} \code{digits} elements.
}
\description{
This function is used within \code{\link[=format_value]{format_value()}} to prepare numeric values within
cells for formatting and display.
}
\details{
This function combines the rounding behavior of R's standards-compliant \code{\link[=round]{round()}}
function (see the Details section of that documentation) with the strict decimal display
of \code{\link[=sprintf]{sprintf()}}. The exact behavior is as follows:

\enumerate{
\item{If \code{x} is \code{NA}, the value of \code{na_str} is returned.}
\item{If \code{x} is non-\code{NA} but \code{digits} is \code{NA}, \code{x} is converted to a character and returned.}
\item{If \code{x} and \code{digits} are both non-NA, \code{\link[=round]{round()}} is called first, and then \code{\link[=sprintf]{sprintf()}}
is used to convert the rounded value to a character with the appropriate number of trailing
zeros enforced.}
}
}
\note{
This differs from the base R \code{\link[=round]{round()}} function in that \code{NA} digits indicate \code{x} should be converted
to character and returned unchanged whereas \code{round(x, digits=NA)} returns \code{NA} for all values of \code{x}.

This behavior will differ from \code{as.character(round(x, digits = digits))} in the case where there are
not at least \code{digits} significant digits after the decimal that remain after rounding. It \emph{may} differ from
\code{sprintf("\\\%.Nf", x)} for values ending in \code{5} after the decimal place on many popular operating systems
due to \code{round}'s stricter adherence to the IEC 60559 standard, particularly for R versions > 4.0.0 (see
warning in \code{\link[=round]{round()}} documentation).
}
\examples{
round_fmt(0, digits = 3)
round_fmt(.395, digits = 2)
round_fmt(NA, digits = 1)
round_fmt(NA, digits = 1, na_str = "-")
round_fmt(2.765923, digits = NA)

}
\seealso{
\code{\link[=format_value]{format_value()}}, \code{\link[=round]{round()}}, \code{\link[=sprintf]{sprintf()}}
}
