% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_add_ui_tooltip}
\alias{FM_add_ui_tooltip}
\title{Add Tooltip to UI Element}
\usage{
FM_add_ui_tooltip(
  state,
  uiele,
  tooltip = "mytooltip",
  position = "right",
  size = "medium"
)
}
\arguments{
\item{state}{Current module state after yaml file has been read.}

\item{uiele}{UI element to add the toooltip to.}

\item{tooltip}{Text containing the tool tip.}

\item{position}{Position of the tooltip.}

\item{size}{size of the tooltip}
}
\value{
If tooltips are enabled and the suggested packages are installed
then a uiele with the tooltip added will be returned. Otherwise it will just
return the original uiele unchanged.
}
\description{
Adds a tool tip to a user element.
}
\examples{
if(interactive()){
# We need a module state object to use this function:
id="UD"
sess_res = UD_test_mksession(session=list(), id=id)
state = sess_res$state
uiele = shiny::textInput(inputId = "my input", label="example input")

uiele = FM_add_ui_tooltip(state, uiele)
}
}
