\name{terms.call}
\Rdversion{1.1}
\alias{terms.call}
\alias{terms.expression}
\alias{terms}

\title{
  terms method for call object
}
\description{
  This S3 method returns a terms object for a call methods using a dispatch to
  \code{ terms.formula }.
}

\usage{
  \method{terms}{call}(x, ...)
  \method{terms}{expression}(x, ...)
}

\arguments{
  \item{x}{ A call object }
  \item{...}{ Arguments passed to \code{\link{terms.formula}} }
}

\details{
  The terms are generated by making a rhs only call to \code{ terms.formula }.

  \code{data} is only needed and must be explicitly specified, i.e. 
  \code{ data = } if there are special elements such as '.'.  Otherwise 
  the \code{data} argument is unused.  

  Some edge cases may not be supported.

}

\value{
  A terms object.  See \code{\link{terms.object}} for details.
}
\author{
  Christopher Brown
}


\seealso{
  \code{\link{terms.object}} and \code{\link{terms.formula}}
}

\examples{

    terms( quote( A + B ) )

    data(iris) 
    x <- terms( quote( . - Species ) , data=iris ) 

}

\keyword{ manip }
\keyword{ symbolmath }
\keyword{ utilities }
