% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPersonPlot.R
\name{missingPersonPlot}
\alias{missingPersonPlot}
\title{Missing person plot}
\usage{
missingPersonPlot(
  reference,
  missing,
  labs = labels(reference),
  marker = NULL,
  hatched = typedMembers(reference),
  MP.label = "MP",
  POI.label = "POI",
  MP.col = "#FF9999",
  POI.col = "lightgreen",
  POI.sex = getSex(reference, missing),
  POI.hatched = NULL,
  titles = c(expression(H[1] * ": POI = MP"), expression(H[2] * ": POI unrelated")),
  width = NULL,
  cex = 1.2,
  ...
)
}
\arguments{
\item{reference}{A \code{\link[pedtools:ped]{pedtools::ped()}} object.}

\item{missing}{The ID label of the missing pedigree member.}

\item{labs}{A character vector with labels for the pedigree members. See
\code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}.}

\item{marker}{Optional vector of marker indices to be included in the plot.}

\item{hatched}{A vector of ID labels indicating who should appear with
hatched symbols in the plot. By default, all typed members.}

\item{MP.label, POI.label}{Custom labels of the missing person and the POI.
Default: "MP" and "POI".}

\item{MP.col, POI.col}{Fill colours for MP and POI.}

\item{POI.sex}{The sex of POI. This defaults to that of the missing person,
but may be set explicitly. This is particularly useful when the missing
person has unknown sex.}

\item{POI.hatched}{Deprecated (ignored).}

\item{titles}{A character of length 2, with subtitles for the two frames.}

\item{width}{A positive number controlling the width of the plot. More
specifically this number is the relative width of the reference pedigree,
compared to a singleton.}

\item{cex}{Expansion factor for pedigree symbols and font size.}

\item{...}{Extra parameters passed on to \code{\link[pedtools:plotPedList]{pedtools::plotPedList()}}.}
}
\value{
None
}
\description{
Visualises the competing hypotheses of a family reunion case. A plot with two
panels is generated. The left panel shows a pedigree in which the \emph{person of
interest} (POI) is identical to the \emph{missing person} (MP). The right panel
shows the situation where these two are unrelated. See Details for further
explanations.
}
\details{
A standard family reunification case involves the following ingredients:
\itemize{
\item A reference family with a single missing person ("MP").
\item Some of the family members have been genotyped
\item A person of interest ("POI") is to be matched against the reference family
}

After genotyping of POI, the genetic evidence is typically assessed by
computing the likelihood ratio of the following hypotheses:
\itemize{
\item H1: POI is MP
\item H2: POI is unrelated to the family
}

The goal of this function is to illustrate the above hypotheses, using
labels, colours and shading to visualise the different aspects of the
situation.

This function cannot handle cases with more complicated hypotheses (e.g.
multiple missing persons, or where H2 specifies a different relationship).
However, as it is basically a wrapper of \code{\link[pedtools:plotPedList]{pedtools::plotPedList()}}, an
interested user should be able to extend the source code to such cases
without too much trouble.
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", children = c("b1", "b2"))

# Default plot
missingPersonPlot(x, missing = "b2")

# Open in separate window; explore various options
missingPersonPlot(x,
                  missing = "b2",
                  hatched = "b1",
                  deceased = c("fa", "mo"),
                  cex = 1.5,      # larger symbols and labels (see ?par())
                  cex.main = 1.3, # larger frame titles (see ?par())
                  dev.width = 7,  # device width (see ?plotPedList())
                  dev.height = 3  # device height (see ?plotPedList())
                  )

}
